<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Bms;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method stockFlowListByParams(array $params)
 * @method stockFlowDetailByParams(array $params)
 * @method stockListByParams(array $params)
 * @method materialStockListByParams(array $params)
 * @method exportCreateByParams(array $params)
 * @method exportDeleteByParams(array $params)
 * @method stockFlowItemListByParams(array $params)
 * @method searchMaterialByParams(array $params)
 * @method stockOtherOutByParams(array $params)
 * @method getStorageServiceByParams(array $params)
 */
class SelfStock {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 出入库记录-出入库记录
     *
     * @support  int $storageId 收货仓库id [ require true ]
     * @support  string $documentType 单据类型 
     * @support  string $associateDocumentNo 上级单据编号 
     * @support  string $createAtBegin 创建开始时间 
     * @support  string $createAtEnd 创建结束时间 
     * @support  int $page 当前页 [Original type uint] [ require true ]
     * @support  int $pageSize 页内条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function stockFlowList () {
        return self::getClass()->stockFlowList();
    }

    /**
     * 出入库记录-出入库详情
     *
     * @param  int $id 出入库详情id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function stockFlowDetail (int $id) {
        return self::getClass()->stockFlowDetail([
            "id" => $id,
        ]);
    }

    /**
     * 库存列表-门店视角
     *
     * @support  string $skuName sku名称 
     * @support  string $skuCode SKU编码 
     * @support  int $isFixedAsset 是否是固定资产, 0是，1不是 
     * @support  int $page 当前页 [Original type uint] [ require true ]
     * @support  int $pageSize 页内条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function stockList () {
        return self::getClass()->stockList();
    }

    /**
     * 库存列表-商品视角
     *
     * @support  int $storageId 仓库id 
     * @support  string $skuName sku名称 
     * @support  string $skuCode SKU编码 
     * @support  int $isFixedAsset 是否是固定资产, 0是，1不是 
     * @support  int $page 当前页 [Original type uint] [ require true ]
     * @support  int $pageSize 页内条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function materialStockList () {
        return self::getClass()->materialStockList();
    }

    /**
     * 库存-导出查询结果
     *
     * @support  int $storageId 仓库id [ require true ]
     * @support  string $skuName sku名称 
     * @support  string $skuCode SKU编码 
     * @support  string $templateId 模板id [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function exportCreate () {
        return self::getClass()->exportCreate();
    }

    /**
     * 库存-导出查询结果删除记录
     *
     * @param  array $taskIds 任务ids [Original type array&lt;string&gt;] [ require true ]
     * @param  array $templateIds 模板ids [Original type array&lt;string&gt;] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function exportDelete (array $taskIds, array $templateIds) {
        return self::getClass()->exportDelete([
            "taskIds" => $taskIds,
            "templateIds" => $templateIds,
        ]);
    }

    /**
     * 库存-库存明细
     *
     * @support  int $storageId 收货仓库id [ require true ]
     * @support  int $skuId 商品skuId [ require true ]
     * @support  int $page 当前页 [Original type uint] [ require true ]
     * @support  int $pageSize 页内条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function stockFlowItemList () {
        return self::getClass()->stockFlowItemList();
    }

    /**
     * 库存-搜索物料
     *
     * @param  string $keyword 搜索关键词 [ require true ]
     * @param  int $storageId 仓库id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function searchMaterial (string $keyword, int $storageId) {
        return self::getClass()->searchMaterial([
            "keyword" => $keyword,
            "storageId" => $storageId,
        ]);
    }

    /**
     * 库存-新增其他出库
     *
     * @support  int $storageId 调整仓库id [ require true ]
     * @support  string $fromType 出库存类型：正品sale_usable_count 样品sample_usable_count 残次defective_count [ require true ]
     * @support  array $itemList 调整sku列表 [ require true ]
     * @support  string $receiver 其他出库收货人 [ require true ]
     * @support  string $remark 备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function stockOtherOut () {
        return self::getClass()->stockOtherOut();
    }

    /**
     * getStorageService
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStorageService () {
        return self::getClass()->getStorageService();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Bms\SelfStock');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Bms\SelfStock');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}