<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Bms;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method waitDeliverNumberByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method detailItemListByParams(array $params)
 * @method checkCreateDataByParams(array $params)
 * @method createByParams(array $params)
 * @method batchCreateByParams(array $params)
 * @method searchMaterialByParams(array $params)
 * @method closeAllocationItemByParams(array $params)
 */
class SelfAllocation {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 零售-待处理调拨单数量
     *
     * @throws  \Exception
     * @return  array
     */
    public static function waitDeliverNumber () {
        return self::getClass()->waitDeliverNumber();
    }

    /**
     * 零售-调拨单列表
     *
     * @support  int $createType 调拨单创建方1是总部2是门店 [ require true ]
     * @support  string $allocationNo 调拨单号 
     * @support  string $allocationType 单据类型 
     * @support  int $toStorageId 收货仓库id 
     * @support  array $status 状态 1未发货，2部分发货，3部分发货完结，4完全发货，5关闭 
     * @support  string $skuName sku名称 
     * @support  int $page 当前页 [Original type uint] [ require true ]
     * @support  int $pageSize 页内条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 调拨单详情
     *
     * @param  int $id 调拨单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 调拨单详情页商品搜索
     *
     * @support  int $id 调拨单id [ require true ]
     * @support  string $skuName sku名字 
     * @support  string $skuCode sku编码 
     * @support  int $page 当前页 [Original type uint] [ require true ]
     * @support  int $pageSize 页内条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detailItemList () {
        return self::getClass()->detailItemList();
    }

    /**
     * 新增调拨并创建发货单-数据检查
     *
     * @param  array $itemList 调拨单sku列表 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function checkCreateData (array $itemList) {
        return self::getClass()->checkCreateData([
            "itemList" => $itemList,
        ]);
    }

    /**
     * 新增调拨
     *
     * @support  int $fromStorageId 收货仓库id [ require true ]
     * @support  int $toStorageId 收货仓库id [ require true ]
     * @support  array $itemList 调拨单sku列表 
     * @support  string $remark 备注 
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 新增批量调拨
     *
     * @support  array $data 调拨单所有sku相关信息 [ require true ]
     * @support  string $remark 备注 
     * @throws  \Exception
     * @return  array
     */
    public static function batchCreate () {
        return self::getClass()->batchCreate();
    }

    /**
     * 搜索物料
     *
     * @param  string $keyword 搜索关键词 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function searchMaterial (string $keyword) {
        return self::getClass()->searchMaterial([
            "keyword" => $keyword,
        ]);
    }

    /**
     * 调拨单详情-关闭调拨单
     *
     * @support  int $id 调拨单id [ require true ]
     * @support  array $itemList 调拨单sku列表 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeAllocationItem () {
        return self::getClass()->closeAllocationItem();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Bms\SelfAllocation');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Bms\SelfAllocation');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}