<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Bms;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method handleByParams(array $params)
 */
class RetailReceiveException {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 异常列表
     *
     * @support  int $fromStorageId 发货仓库id 
     * @support  int $toStorageId 收货仓库id 
     * @support  string $receiveNo 收货单号 
     * @support  int $status 状态 1提交，2处理完成 
     * @support  string $skuName sku名字 
     * @support  int $page 当前页 [Original type uint] [ require true ]
     * @support  int $pageSize 页内条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 处理异常
     *
     * @support  int $receiveItemId 发货单明细id [ require true ]
     * @support  int $skuId skuId [ require true ]
     * @param  int $errorNumByFrom 计入发货方库存 [ require true ]
     * @param  int $errorNumByTo 计入收货方库存 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function handle (int $errorNumByFrom, int $errorNumByTo) {
        return self::getClass()->handle([
            "errorNumByFrom" => $errorNumByFrom,
            "errorNumByTo" => $errorNumByTo,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Bms\RetailReceiveException');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Bms\RetailReceiveException');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}