<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getMonthMainByParams(array $params)
 * @method detailByStoreByParams(array $params)
 * @method changeCountByParams(array $params)
 * @method autoConfirmByParams(array $params)
 * @method createByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method resubmitByParams(array $params)
 */
class PurchaseMain {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取门店最新的主配订单
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMonthMain () {
        return self::getClass()->getMonthMain();
    }

    /**
     * 详情(门店端)
     *
     * @param  int $id id, main里面的id [Original type uint] [ require true ]
     * @param  string $name 物料名称 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detailByStore (int $id, string $name = '') {
        return self::getClass()->detailByStore([
            "id" => $id,
            "name" => $name,
        ]);
    }

    /**
     * 门店确认（调整数量）
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @param  array $info info [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeCount (int $id, array $info = []) {
        return self::getClass()->changeCount([
            "id" => $id,
            "info" => $info,
        ]);
    }

    /**
     * 自动确认
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoConfirm () {
        return self::getClass()->autoConfirm();
    }

    /**
     * 创建主配订单
     *
     * @param  array $storeIds 门店ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (array $storeIds = []) {
        return self::getClass()->create([
            "storeIds" => $storeIds,
        ]);
    }

    /**
     * 列表
     *
     * @support  string $startAt 开始时间 
     * @support  string $endAt 结束时间 
     * @support  int $storeId 门店id [Original type uint] 
     * @support  string $status 状态 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 详情
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 重新提交
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function resubmit (int $id) {
        return self::getClass()->resubmit([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'PurchaseMain');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'PurchaseMain');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}