<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Store;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method stockFlowListByParams(array $params)
 * @method stockFlowDetailByParams(array $params)
 * @method listByParams(array $params)
 * @method exportByParams(array $params)
 * @method detailByParams(array $params)
 */
class RetailStock {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 出入库记录
     *
     * @support  int $storageId 收货仓库id [ require true ]
     * @support  string $documentType 单据类型 
     * @support  string $associateDocumentNo 上级单据编号 
     * @support  string $createAtBegin 创建开始时间 
     * @support  string $createAtEnd 创建结束时间 
     * @support  int $page 当前页 [Original type uint] [ require true ]
     * @support  int $pageSize 页内条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function stockFlowList () {
        return self::getClass()->stockFlowList();
    }

    /**
     * 出入库详情
     *
     * @param  int $id 出入库详情id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function stockFlowDetail (int $id) {
        return self::getClass()->stockFlowDetail([
            "id" => $id,
        ]);
    }

    /**
     * 库存列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 导出查询结果 export
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function export () {
        return self::getClass()->export();
    }

    /**
     * 库存明细
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Store\RetailStock');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Store\RetailStock');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}