<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Store;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method waitDeliverNumberByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method detailItemListByParams(array $params)
 * @method createByParams(array $params)
 * @method searchProductByParams(array $params)
 * @method shipByParams(array $params)
 */
class RetailAllocation {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 零售-待处理调拨单数量
     *
     * @param  int $storeId 门店ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function waitDeliverNumber (int $storeId) {
        return self::getClass()->waitDeliverNumber([
            "storeId" => $storeId,
        ]);
    }

    /**
     * 零售-调拨单列表
     *
     * @support  int $createType 调拨单创建方1是总部2是门店 [ require true ]
     * @support  string $allocationNo 调拨单号 
     * @support  string $allocationType 单据类型 
     * @support  int $toStorageId 收货仓库id 
     * @support  array $status 状态 1未发货，2部分发货，3部分发货完结，4完全发货，5关闭 
     * @support  string $skuName sku名称 
     * @support  int $page 当前页 [Original type uint] [ require true ]
     * @support  int $pageSize 页内条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 调拨单详情
     *
     * @param  int $id 调拨单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 调拨单详情页商品搜索
     *
     * @support  int $id 调拨单id [ require true ]
     * @support  string $skuName sku名字 
     * @support  string $skuCode sku编码 
     * @support  int $page 当前页 [Original type uint] [ require true ]
     * @support  int $pageSize 页内条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detailItemList () {
        return self::getClass()->detailItemList();
    }

    /**
     * 新增调拨
     *
     * @support  int $toStorageId 收货仓库id [ require true ]
     * @support  array $itemList 调拨单sku列表 
     * @support  string $remark 备注 
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 搜索商品
     *
     * @param  string $keyword 搜索关键词 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function searchProduct (string $keyword) {
        return self::getClass()->searchProduct([
            "keyword" => $keyword,
        ]);
    }

    /**
     * 调拨单发货
     *
     * @support  int $id 调拨单id [ require true ]
     * @support  array $itemList 调拨单sku列表 
     * @support  string $remark 备注 
     * @support  array $trackingNumbers 物流单号 
     * @support  int $fromMemberId 发货人ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function ship () {
        return self::getClass()->ship();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Store\RetailAllocation');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Store\RetailAllocation');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}