<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method closeByParams(array $params)
 * @method receiveByParams(array $params)
 */
class PurchaseReceive {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 列表
     *
     * @support  string $receiveNo 收货单号 
     * @support  string $createdAtStart 创建开始时间 
     * @support  string $createdAtEnd 创建结束时间 
     * @support  string $receiveBy 供应商id 
     * @support  int $createBy 创建人工号 [Original type uint] 
     * @support  string $status 状态 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 详情
     *
     * @param  int $receiveId 收货单id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $receiveId) {
        return self::getClass()->detail([
            "receiveId" => $receiveId,
        ]);
    }

    /**
     * 关闭
     *
     * @param  int $receiveId 收货单id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function close (int $receiveId) {
        return self::getClass()->close([
            "receiveId" => $receiveId,
        ]);
    }

    /**
     * 批量收货
     *
     * @param  array $data 收货单信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function receive (array $data) {
        return self::getClass()->receive([
            "data" => $data,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'PurchaseReceive');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'PurchaseReceive');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}