<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method isDemandTimeOrNotByParams(array $params)
 * @method autoUpdatePurchaseCountLimitByParams(array $params)
 * @method getDemandListByParams(array $params)
 * @method getDemandAndSkuListByParams(array $params)
 * @method searchDemandBySkuIdByParams(array $params)
 * @method detailByParams(array $params)
 * @method detailAndSkuByParams(array $params)
 * @method callbackDingProcessByParams(array $params)
 * @method createByParams(array|\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseDemand\CMD\StorePurchaseDemandAddCMD $params)
 * @method resendApproveByParams(array $params)
 * @method batchDealByParams(array $params)
 * @method batchCloseByParams(array $params)
 * @method itemListByParams(array $params)
 * @method updateCountLimitByParams(array $params)
 * @method purchaseDemandBatchCloseNoticeByParams(array $params)
 * @method getDemandTypeListByParams(array $params)
 * @method purchaseForecastByParams(array $params)
 * @method unsetPurchaseForecastByParams(array|\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseDemand\CMD\UnsetPurchaseForecastListReq $params)
 * @method createDemandOrderTypeByParams(array $params)
 */
class PurchaseDemand {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 是否是需求单时间
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function isDemandTimeOrNot () {
        return self::getClass()->isDemandTimeOrNot();
    }

    /**
     * 每个月自动更新门店物料的剩余采购数量
     *
     * @throws  \Exception
     * @return  int
     */
    public static function autoUpdatePurchaseCountLimit () {
        return self::getClass()->autoUpdatePurchaseCountLimit();
    }

    /**
     * 需求单列表
     *
     * @support  string $type 类型 [ require false ]
     * @support  string $startTime 开始时间 [ require false ]
     * @support  string $endTime 结束时间 [ require false ]
     * @support  string $status 单据状态 [ require false ]
     * @support  int $createBy 申请人工号 [ require false ]
     * @support  int $skuId 物料skuId [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getDemandList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getDemandList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 供应链助手采购申请
     *
     * @support  string $type 类型 [ require false ]
     * @support  string $startTime 开始时间 [ require false ]
     * @support  string $endTime 结束时间 [ require false ]
     * @support  string $status 单据状态 [ require false ]
     * @support  int $createBy 申请人工号 [ require false ]
     * @support  int $skuId 物料skuId [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getDemandAndSkuList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getDemandAndSkuList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 供应链助手采购申请-按物料搜
     *
     * @support  int $skuId 物料skuId [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function searchDemandBySkuId () {
        return self::getClass()->searchDemandBySkuId([
        ]);
    }

    /**
     * 需求单详情
     *
     * @support  int $id 需求单id [ require true ]
     * @support  string $skuName sku名字 [ require false ]
     * @support  string $skuCode sku编码 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail () {
        return self::getClass()->detail([
        ]);
    }

    /**
     * 供应链助手需求单详情
     *
     * @support  int $id 需求单id [ require true ]
     * @support  string $skuName sku名字 [ require false ]
     * @support  string $skuCode sku编码 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function detailAndSku () {
        return self::getClass()->detailAndSku([
        ]);
    }

    /**
     * 钉钉审批回调
     *
     * @throws  \Exception
     * @return  string
     */
    public static function callbackDingProcess () {
        return self::getClass()->callbackDingProcess();
    }

    /**
     * 创建需求单
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseDemand\CMD\StorePurchaseDemandAddCMD $addCMD
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseDemand\CMD\StorePurchaseDemandAddCMD $addCMD) {
        return self::getClass()->create($addCMD);
    }


    /**
     * 重新发起需求单审批
     *
     * @param  array $demandIds 需求单IDs [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function resendApprove (array $demandIds) {
        return self::getClass()->resendApprove([
            "demandIds" => $demandIds,
        ]);
    }

    /**
     * 批量处理
     *
     * @param  array $demandItemIds 需求单明细ids [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchDeal (array $demandItemIds) {
        return self::getClass()->batchDeal([
            "demandItemIds" => $demandItemIds,
        ]);
    }

    /**
     * 批量关闭
     *
     * @param  array $demandItemIds 需求单明细ids [ require true ]
     * @param  string $closeReason 关闭原因 [ require true ]
     * @param  int $closeType 关闭类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function batchClose (array $demandItemIds, string $closeReason, int $closeType) {
        return self::getClass()->batchClose([
            "demandItemIds" => $demandItemIds,
            "closeReason" => $closeReason,
            "closeType" => $closeType,
        ]);
    }

    /**
     * 明细列表
     *
     * @support  string $demandNo 需求单号 [ require false ]
     * @support  string $orderNo 采购单号 [ require false ]
     * @support  int $createBy 下单人id [ require false ]
     * @support  string $createdAtStart 创建开始时间 [ require false ]
     * @support  string $createdAtEnd 创建结束时间 [ require false ]
     * @support  array $materialIds 物料id [ require false ]
     * @support  array $skuIds skuIds [ require false ]
     * @support  int $productTagIds 标签id [ require false ]
     * @support  int $toStorageId 收货方id [ require false ]
     * @support  int $supplierId 供应商id [ require false ]
     * @support  int $buyerId 采购员id [ require false ]
     * @support  string $deliveryType 发货方式 [ require false ]
     * @support  array $status 状态 [ require false ]
     * @support  string $approveAtStart 审批通过开始时间 [ require false ]
     * @support  string $approveAtEnd 审批通过结束时间 [ require false ]
     * @support  array $type 采购类型，支持多选 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页记录数 [ require false ]
     * @support  int $searchAfter 当前页面的最大id [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function itemList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->itemList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 更新采购上限数量
     *
     * @param  array $storeIds 门店ids [ require true ]
     * @param  array $details 数量集合 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updateCountLimit (array $storeIds, array $details) {
        return self::getClass()->updateCountLimit([
            "storeIds" => $storeIds,
            "details" => $details,
        ]);
    }

    /**
     * 需求单关闭发送玎钉通知
     *
     * @param  int $staffId 推送id [ require true ]
     * @param  string $content 推送消息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function purchaseDemandBatchCloseNotice (int $staffId, string $content) {
        return self::getClass()->purchaseDemandBatchCloseNotice([
            "staffId" => $staffId,
            "content" => $content,
        ]);
    }

    /**
     * 获取采买类型列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getDemandTypeList () {
        return self::getClass()->getDemandTypeList();
    }

    /**
     * 采购预测
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseDemand\DTO\PurchaseForecastListRes
     */
    public static function purchaseForecast () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->purchaseForecast(),
            "\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseDemand\DTO\PurchaseForecastListRes"
        );
    }

    /**
     * 失效预测
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseDemand\CMD\UnsetPurchaseForecastListReq $unsetPurchaseForecastListReq
     * @throws  \Exception
     * @return  bool
     */
    public static function unsetPurchaseForecast (\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseDemand\CMD\UnsetPurchaseForecastListReq $unsetPurchaseForecastListReq) {
        return self::getClass()->unsetPurchaseForecast($unsetPurchaseForecastListReq);
    }


    /**
     * 门店申请采购申请原因
     *
     * @param  string $type 类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function createDemandOrderType (string $type) {
        return self::getClass()->createDemandOrderType([
            "type" => $type,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'PurchaseDemand');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'PurchaseDemand');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}