<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Bms;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method searchProductByParams(array $params)
 * @method searchItemsByParams(array $params)
 * @method exportBatchShipAddByParams(array $params)
 * @method allocationsRetryToEbsByParams(array $params)
 */
class RetailAllocation {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 搜索商品-物料表搜
     *
     * @param  string $keyword 搜索关键词 [ require true ]
     * @param  int $storageId 搜索仓库 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function searchProduct (string $keyword, int $storageId = 0) {
        return self::getClass()->searchProduct([
            "keyword" => $keyword,
            "storageId" => $storageId,
        ]);
    }

    /**
     * 搜索商品-批量搜索物料库存
     *
     * @support  array $items items [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function searchItems () {
        return self::getClass()->searchItems([
        ]);
    }

    /**
     * 批量发货模板下载-导出查询结果
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $params 参数 [ require false ]
     * @throws  \Exception
     * @return  string
     */
    public static function exportBatchShipAdd () {
        return self::getClass()->exportBatchShipAdd([
        ]);
    }

    /**
     * 重试 推送ebs失败的调拨单
     *
     * @param  array $allocationNos 调拨单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function allocationsRetryToEbs (array $allocationNos) {
        return self::getClass()->allocationsRetryToEbs([
            "allocationNos" => $allocationNos,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Bms\RetailAllocation');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Bms\RetailAllocation');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}