<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-13 15:58:09
 */
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Store;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class SelfScrap
 * @method storeDealScrapAndInventoryByParams(array $params) [领用助手]-首页获取盘点+报废处理单数量
 * @method missionAndSkuListByParams(array $params) [报废任务] 门店报废单列表
 * @method detailByParams(array $params) [报废任务] 门店报废单详情
 * @method checkByParams(array $params) [报废任务] 提交报废单
 * @method getMissionStatusCountByParams(array $params) [报废任务] 任务状态数量
 * @method missionListByParams(array $params) [报废任务]列表
 * @method newTaskExportScrapProcessByParams(array $params) 门店报废审批导出
 */
class SelfScrap {
    private static string $serviceName = "ProjectSupplyChain";

    private static string $className = "Store\\SelfScrap";

    /**
     * [领用助手]-首页获取盘点+报废处理单数量
     * @return  int
    */
    public static function storeDealScrapAndInventory () {
        return RpcClass::getClass(self::$serviceName, self::$className)->storeDealScrapAndInventory();
    }

    /**
     * [报废任务] 门店报废单列表
     * @return  array
    */
    public static function missionAndSkuList (?\Mainto\Bridge\Structs\ProjectSupplyChain\Scrap\Cmd\ScrapMissionAndSkuListCMD $scrapMissionAndSkuListCMD = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->missionAndSkuList($scrapMissionAndSkuListCMD);
    }

    /**
     * [报废任务] 门店报废单详情
     * @return  array
    */
    public static function detail (\Mainto\Bridge\Structs\ProjectSupplyChain\Scrap\Cmd\ScrapDetailCMD $scrapDetailCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail($scrapDetailCMD);
    }

    /**
     * [报废任务] 提交报废单
     * @return  \Mainto\Bridge\Structs\ProjectSupplyChain\Basic\DTO\CheckScrapErrDTO
    */
    public static function check (\Mainto\Bridge\Structs\ProjectSupplyChain\Scrap\Cmd\ScrapCheckCMD $scrapCheckCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->check($scrapCheckCMD),
            "\Mainto\Bridge\Structs\ProjectSupplyChain\Basic\DTO\CheckScrapErrDTO"
        );
    }

    /**
     * [报废任务] 任务状态数量
     * @return  array
    */
    public static function getMissionStatusCount () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMissionStatusCount();
    }

    /**
     * [报废任务]列表
     * @return  array
    */
    public static function missionList (?\Mainto\Bridge\Structs\ProjectSupplyChain\Scrap\Cmd\ScrapMissionListCMD $scrapMissionListCMD = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->missionList($scrapMissionListCMD);
    }

    /**
     * 门店报废审批导出
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  string
    */
    public static function newTaskExportScrapProcess (string $template_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->newTaskExportScrapProcess(["template_id" => $template_id]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}