<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-13 15:58:09
 */
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Staff
 * @method listByParams(array $params) 根据门店id获取员工列表
 * @method getDeptStaffListByParams(array $params) 根据部门id获取员工列表
 * @method getAllStaffsByParams(array $params) 获取所有员工
 * @method getAllStaffsByIdByParams(array $params) 通过id获取伙伴信息
 * @method removeAllStaffsCacheByParams(array $params) removeAllStaffsCache
 * @method getPermissionStaffByParams(array $params) 获取拥有某个权限的伙伴信息
 * @method getUserTagsByParams(array $params) 获取伙伴信息
 */
class Staff {
    private static string $serviceName = "ProjectSupplyChain";

    private static string $className = "Staff";

    /**
     * 根据门店id获取员工列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function list (int $storeId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["storeId" => $storeId]);
    }

    /**
     * 根据部门id获取员工列表
     * @return  array
    */
    public static function getDeptStaffList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getDeptStaffList();
    }

    /**
     * 获取所有员工
     * @return  array
    */
    public static function getAllStaffs () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllStaffs();
    }

    /**
     * 通过id获取伙伴信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getAllStaffsById (int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllStaffsById(["staffId" => $staffId]);
    }

    /**
     * removeAllStaffsCache
     * @return  bool
    */
    public static function removeAllStaffsCache () {
        return RpcClass::getClass(self::$serviceName, self::$className)->removeAllStaffsCache();
    }

    /**
     * 获取拥有某个权限的伙伴信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getPermissionStaff (int $permissionId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPermissionStaff(["permissionId" => $permissionId]);
    }

    /**
     * 获取伙伴信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getUserTags (int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserTags(["staffId" => $staffId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}