<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-13 15:58:09
 */
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class PurchaseReturn
 * @method createByParams(array $params) 创建退货单
 * @method getCreatInfoByParams(array $params) 创建前退货单明细
 * @method getDetailByParams(array $params) 获取退货单子单(退货单详情)
 * @method getListPaginationByParams(array $params) 获取退货单分页
 * @method approvalRevokeByParams(array $params) 撤回审批
 * @method updateStatusByParams(array $params) 更新状态
 * @method updateReturnByParams(array $params) 更新退货单
 * @method callRetryReturnEbsByParams(array $params) ebs重推方法
 */
class PurchaseReturn {
    private static string $serviceName = "ProjectSupplyChain";

    private static string $className = "PurchaseReturn";

    /**
     * 创建退货单
     * @return  bool
    */
    public static function create (\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseReturn\CMD\PurchaseReturnCreateReq $purchaseReturnCreateReq) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create($purchaseReturnCreateReq);
    }

    /**
     * 创建前退货单明细
     * @return  \Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseReturn\DTO\PurchaseReturnCreateInfoRes
    */
    public static function getCreatInfo (\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseReturn\CMD\PurchaseReturnCreatInfoReq $purchaseReturnCreatInfoReq) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getCreatInfo($purchaseReturnCreatInfoReq),
            "\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseReturn\DTO\PurchaseReturnCreateInfoRes"
        );
    }

    /**
     * 获取退货单子单(退货单详情)
     * @return  \Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseReturn\DTO\PurchaseReturnReturnDetailRes
    */
    public static function getDetail (\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseReturn\CMD\PurchaseReturnDetailReq $purchaseReturnDetailReq) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getDetail($purchaseReturnDetailReq),
            "\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseReturn\DTO\PurchaseReturnReturnDetailRes"
        );
    }

    /**
     * 获取退货单分页
     * @return  \Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseReturn\DTO\PurchaseReturnReturnPageListRes
    */
    public static function getListPagination (\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseReturn\CMD\PurchaseReturnPageReq $purchaseReturnPageReq) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getListPagination($purchaseReturnPageReq),
            "\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseReturn\DTO\PurchaseReturnReturnPageListRes"
        );
    }

    /**
     * 撤回审批
     * @return  bool
    */
    public static function approvalRevoke (\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseReturn\CMD\PurchaseReturnApprovalRevokeReq $purchaseReturnApprovalRevokeReq) {
        return RpcClass::getClass(self::$serviceName, self::$className)->approvalRevoke($purchaseReturnApprovalRevokeReq);
    }

    /**
     * 更新状态
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function updateStatus (int $returnId, string $status) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateStatus(["returnId" => $returnId, "status" => $status]);
    }

    /**
     * 更新退货单
     * @return  bool
    */
    public static function updateReturn (\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseReturn\CMD\PurchaseReturnUpdateReq $purchaseReturnUpdateReq) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateReturn($purchaseReturnUpdateReq);
    }

    /**
     * ebs重推方法
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function callRetryReturnEbs () {
        return RpcClass::getClass(self::$serviceName, self::$className)->callRetryReturnEbs([]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}