<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-13 15:58:09
 */
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class PurchaseRefund
 * @method createByParams(array $params) 创建退款单
 * @method updatePurchaseRefundByParams(array $params) 更新退款单
 * @method submitPurchaseRefundByParams(array $params) 退款单提交/完成
 * @method getListPaginationByParams(array $params) 分页查询退款单列表
 * @method getCreateInfoByParams(array $params) 退款单创建前信息
 * @method getListByParams(array $params) 退款单列表不分页
 * @method approvalRevokeByParams(array $params) 审批单撤回
 * @method updateStatusByParams(array $params) 更新状态
 * @method getDetailByParams(array $params) 获取退款单详情
 */
class PurchaseRefund {
    private static string $serviceName = "ProjectSupplyChain";

    private static string $className = "PurchaseRefund";

    /**
     * 创建退款单
     * @return  bool
    */
    public static function create (\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseRefund\CMD\CreatePurchaseRefundReq $createPurchaseRefundReq) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create($createPurchaseRefundReq);
    }

    /**
     * 更新退款单
     * @return  bool
    */
    public static function updatePurchaseRefund (\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseRefund\CMD\PurchaseRefundUpdateReq $purchaseRefundUpdateReq) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updatePurchaseRefund($purchaseRefundUpdateReq);
    }

    /**
     * 退款单提交/完成
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function submitPurchaseRefund (int $refundId, int $updatedBy) {
        return RpcClass::getClass(self::$serviceName, self::$className)->submitPurchaseRefund(["refundId" => $refundId, "updatedBy" => $updatedBy]);
    }

    /**
     * 分页查询退款单列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseRefund\DTO\PurchaseRefundPageListRes
    */
    public static function getListPagination () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getListPagination([]),
            "\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseRefund\DTO\PurchaseRefundPageListRes"
        );
    }

    /**
     * 退款单创建前信息
     * @return  \Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseRefund\DTO\PurchaseRefundCreateInfoRes
    */
    public static function getCreateInfo (\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseRefund\CMD\PurchaseRefundCreateInfoReq $purchaseRefundCreateInfoReq) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getCreateInfo($purchaseRefundCreateInfoReq),
            "\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseRefund\DTO\PurchaseRefundCreateInfoRes"
        );
    }

    /**
     * 退款单列表不分页
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getList([]);
    }

    /**
     * 审批单撤回
     * @return  bool
    */
    public static function approvalRevoke (\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseRefund\CMD\PurchaseApprovalRevokeReq $purchaseApprovalRevokeReq) {
        return RpcClass::getClass(self::$serviceName, self::$className)->approvalRevoke($purchaseApprovalRevokeReq);
    }

    /**
     * 更新状态
     * @return  bool
    */
    public static function updateStatus (\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseRefund\CMD\PurchaseUpdateStatusReq $purchaseUpdateStatusReq) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateStatus($purchaseUpdateStatusReq);
    }

    /**
     * 获取退款单详情
     * @return  \Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseReturn\DTO\PurchaseRefundInfoRes
    */
    public static function getDetail (\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseReturn\CMD\PurchaseRefundInfoReq $purchaseRefundInfoReq) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getDetail($purchaseRefundInfoReq),
            "\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseReturn\DTO\PurchaseRefundInfoRes"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}