<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-13 15:58:08
 */
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class PurchaseAdvance
 * @method createByParams(array $params) 创建预付款单
 * @method listByParams(array $params) 列表
 * @method detailByParams(array $params) 详情
 * @method updateByParams(array $params) 更新
 * @method closeByParams(array $params) 关闭
 * @method revokeByParams(array $params) 撤销审批
 * @method submitByParams(array $params) 提交审批
 * @method callbackDingProcessByParams(array $params) 钉钉审批回调
 * @method getCreateByInfosByParams(array $params) 获取创建人s
 * @method newGetCreateByInfosByParams(array $params) 新获取创建人s
 * @method getLogByParams(array $params) 获取日志信息
 */
class PurchaseAdvance {
    private static string $serviceName = "ProjectSupplyChain";

    private static string $className = "PurchaseAdvance";

    /**
     * 创建预付款单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function create (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["orderId" => $orderId]);
    }

    /**
     * 列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function list (int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function detail (int $advanceId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["advanceId" => $advanceId]);
    }

    /**
     * 更新
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function update (int $advanceId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(["advanceId" => $advanceId]);
    }

    /**
     * 关闭
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function close (int $advanceId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->close(["advanceId" => $advanceId]);
    }

    /**
     * 撤销审批
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function revoke (int $advanceId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->revoke(["advanceId" => $advanceId]);
    }

    /**
     * 提交审批
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function submit (int $advanceId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->submit(["advanceId" => $advanceId]);
    }

    /**
     * 钉钉审批回调
     * @return  string
    */
    public static function callbackDingProcess () {
        return RpcClass::getClass(self::$serviceName, self::$className)->callbackDingProcess();
    }

    /**
     * 获取创建人s
     * @return  array
    */
    public static function getCreateByInfos () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCreateByInfos();
    }

    /**
     * 新获取创建人s
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function newGetCreateByInfos (string $nameOrNickname) {
        return RpcClass::getClass(self::$serviceName, self::$className)->newGetCreateByInfos(["nameOrNickname" => $nameOrNickname]);
    }

    /**
     * 获取日志信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getLog (int $entityId, int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getLog(["entityId" => $entityId, "page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}