<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-13 15:58:09
 */
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Bms;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class SelfAllocation
 * @method listByParams(array $params) 调拨单列表
 * @method detailByParams(array $params) 调拨单详情
 * @method detailItemListByParams(array $params) 调拨单详情页商品搜索
 * @method getPredictDataByParams(array $params) 调拨,单条发货时间检查
 * @method getBatchPredictDataByParams(array $params) 调拨,多条发货时间检查
 * @method createByParams(array $params) 新增调拨
 * @method batchCreateByParams(array $params) 新增批量调拨
 * @method searchMaterialByParams(array $params) 搜索物料-物料表搜
 * @method exportBatchShipAddByParams(array $params) 批量发货模板下载-导出查询结果
 * @method getStorageServiceByParams(array $params) getStorageService
 */
class SelfAllocation {
    private static string $serviceName = "ProjectSupplyChain";

    private static string $className = "Bms\\SelfAllocation";

    /**
     * 调拨单列表
     * @return  array
    */
    public static function list (?\Mainto\Bridge\Structs\ProjectSupplyChain\Allocation\CMD\AllocationPaginateSearchCMD $allocationPaginateSearchCMD = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list($allocationPaginateSearchCMD);
    }

    /**
     * 调拨单详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\ProjectSupplyChain\Allocation\DTO\AllocationDetailDTO
    */
    public static function detail (int $id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]),
            "\Mainto\Bridge\Structs\ProjectSupplyChain\Allocation\DTO\AllocationDetailDTO"
        );
    }

    /**
     * 调拨单详情页商品搜索
     * @return  \Mainto\Bridge\Structs\ProjectSupplyChain\Allocation\DTO\AllocationItemPageDTO
    */
    public static function detailItemList (?\Mainto\Bridge\Structs\ProjectSupplyChain\Allocation\CMD\AllocationItemPaginateSearchCMD $allocationItemPaginateSearchCMD = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->detailItemList($allocationItemPaginateSearchCMD),
            "\Mainto\Bridge\Structs\ProjectSupplyChain\Allocation\DTO\AllocationItemPageDTO"
        );
    }

    /**
     * 调拨,单条发货时间检查
     * @return  \Mainto\Bridge\Structs\ProjectSupplyChain\Basic\DTO\ErrDTO
    */
    public static function getPredictData (\Mainto\Bridge\Structs\ProjectSupplyChain\Allocation\CMD\AllocationAddCMD $allocationAddCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getPredictData($allocationAddCMD),
            "\Mainto\Bridge\Structs\ProjectSupplyChain\Basic\DTO\ErrDTO"
        );
    }

    /**
     * 调拨,多条发货时间检查
     * @return  \Mainto\Bridge\Structs\ProjectSupplyChain\Basic\DTO\ErrDTO
    */
    public static function getBatchPredictData (\Mainto\Bridge\Structs\ProjectSupplyChain\Allocation\CMD\AllocationBatchAddCMD $allocationBatchAddCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getBatchPredictData($allocationBatchAddCMD),
            "\Mainto\Bridge\Structs\ProjectSupplyChain\Basic\DTO\ErrDTO"
        );
    }

    /**
     * 新增调拨
     * @return  \Mainto\Bridge\Structs\ProjectSupplyChain\Basic\DTO\CheckPassDTO
    */
    public static function create (\Mainto\Bridge\Structs\ProjectSupplyChain\Allocation\CMD\AllocationAddCMD $allocationAddCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->create($allocationAddCMD),
            "\Mainto\Bridge\Structs\ProjectSupplyChain\Basic\DTO\CheckPassDTO"
        );
    }

    /**
     * 新增批量调拨
     * @return  mixed
    */
    public static function batchCreate (\Mainto\Bridge\Structs\ProjectSupplyChain\Allocation\CMD\AllocationBatchAddCMD $allocationBatchAddCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchCreate($allocationBatchAddCMD);
    }

    /**
     * 搜索物料-物料表搜
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function searchMaterial (string $keyword) {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchMaterial(["keyword" => $keyword]);
    }

    /**
     * 批量发货模板下载-导出查询结果
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  string
    */
    public static function exportBatchShipAdd (string $template_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->exportBatchShipAdd(["template_id" => $template_id]);
    }

    /**
     * getStorageService
     * @return  mixed
    */
    public static function getStorageService () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStorageService();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}