<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-08-09 15:45:45
 */
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Supplier
 * @method getListPageByParams(array $params) getListPage
 * @method getAccountListByParams(array $params) getAccountList
 * @method createAccountByParams(array $params) createAccount
 * @method editSupplierInfoByParams(array $params) editSupplierInfo
 * @method delAccountByParams(array $params) delAccount
 * @method getAllSuppliersByParams(array $params) 获取所有供应商
 * @method getSuppliersByParams(array $params) 获取供应商s
 * @method syncSupplierByParams(array $params) 同步供应商信息
 * @method getBuyerSuppliersByParams(array $params) 通过采购用户id获取供应商id列表
 * @method getAllSupplyStorageIdsByParams(array $params) 获取开启供应商协同的storageids
 */
class Supplier {
    private static string $serviceName = "ProjectSupplyChain";

    private static string $className = "Supplier";

    /**
     * getListPage
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getListPage (int $page = 1, int $pageSize = 15) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getListPage(["page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * getAccountList
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getAccountList (int $supplierId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAccountList(["supplierId" => $supplierId]);
    }

    /**
     * createAccount
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function createAccount (int $supplierId, string $phone, string $nickName) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createAccount(["supplierId" => $supplierId, "phone" => $phone, "nickName" => $nickName]);
    }

    /**
     * editSupplierInfo
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function editSupplierInfo (int $supplierId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editSupplierInfo(["supplierId" => $supplierId]);
    }

    /**
     * delAccount
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function delAccount (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delAccount(["id" => $id]);
    }

    /**
     * 获取所有供应商
     * @return  array
    */
    public static function getAllSuppliers () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllSuppliers();
    }

    /**
     * 获取供应商s
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getSuppliers (string $name = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSuppliers(["name" => $name]);
    }

    /**
     * 同步供应商信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function syncSupplier (string $name, int $nsId = 0, float $prepaidRate = 0, array $extend = [], array $details = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->syncSupplier(["name" => $name, "nsId" => $nsId, "prepaidRate" => $prepaidRate, "extend" => $extend, "details" => $details]);
    }

    /**
     * 通过采购用户id获取供应商id列表
     * @return  array
    */
    public static function getBuyerSuppliers () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getBuyerSuppliers();
    }

    /**
     * 获取开启供应商协同的storageids
     * @return  array
    */
    public static function getAllSupplyStorageIds () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllSupplyStorageIds();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}