<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-08-09 15:45:45
 */
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Store;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class SelfInventory
 * @method listByParams(array $params) 自用盘点列表
 * @method checkDetailByParams(array $params) 盘点详情页面
 * @method getMissionDetailByParams(array $params) (盘点助手) 盘点任务详情
 * @method searchSkuByParams(array $params) (盘点助手) 盘点任务详情 sku搜索
 * @method stashByParams(array $params) (盘点助手) 盘点任务提交暂存信息
 * @method checkByParams(array $params) check
 * @method recheckByParams(array $params) recheck
 * @method importStoreStockByParams(array $params) importStoreStock
 * @method storageStockBySkuIdByParams(array $params) 获取门店里指定skuid的库存信息
 * @method getMissionAndSkuListByParams(array $params) (盘点助手) 盘点任务列表
 * @method getMissionStatusCountByParams(array $params) (盘点助手) 盘点任务状态数量
 */
class SelfInventory {
    private static string $serviceName = "ProjectSupplyChain";

    private static string $className = "Store\\SelfInventory";

    /**
     * 自用盘点列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function list (int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 盘点详情页面
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function checkDetail (int $page = 1, int $pageSize = 10, int $inventoryId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkDetail(["page" => $page, "pageSize" => $pageSize, "inventoryId" => $inventoryId]);
    }

    /**
     * (盘点助手) 盘点任务详情
     * @return  array
    */
    public static function getMissionDetail (?\Mainto\Bridge\Structs\ProjectSupplyChain\Inventory\Cmd\GetMissionDetailCmd $getMissionDetailCmd = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMissionDetail($getMissionDetailCmd);
    }

    /**
     * (盘点助手) 盘点任务详情 sku搜索
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function searchSku (int $inventoryId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchSku(["inventoryId" => $inventoryId]);
    }

    /**
     * (盘点助手) 盘点任务提交暂存信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function stash (array $skuInfos) {
        return RpcClass::getClass(self::$serviceName, self::$className)->stash(["skuInfos" => $skuInfos]);
    }

    /**
     * check
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function check (array $skuInfos, string $inventoryType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->check(["skuInfos" => $skuInfos, "inventoryType" => $inventoryType]);
    }

    /**
     * recheck
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function recheck (int $inventoryId, array $skuInfos) {
        return RpcClass::getClass(self::$serviceName, self::$className)->recheck(["inventoryId" => $inventoryId, "skuInfos" => $skuInfos]);
    }

    /**
     * importStoreStock
     * @return  array
    */
    public static function importStoreStock () {
        return RpcClass::getClass(self::$serviceName, self::$className)->importStoreStock();
    }

    /**
     * 获取门店里指定skuid的库存信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function storageStockBySkuId (array $skuids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->storageStockBySkuId(["skuids" => $skuids]);
    }

    /**
     * (盘点助手) 盘点任务列表
     * @return  array
    */
    public static function getMissionAndSkuList (?\Mainto\Bridge\Structs\ProjectSupplyChain\Inventory\Cmd\GetMissionAndSkuListCmd $getMissionAndSkuListCmd = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMissionAndSkuList($getMissionAndSkuListCmd);
    }

    /**
     * (盘点助手) 盘点任务状态数量
     * @return  array
    */
    public static function getMissionStatusCount () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMissionStatusCount();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}