<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-08-09 15:45:45
 */
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Receive
 * @method listByParams(array $params) 列表
 * @method detailByParams(array $params) 收货单详情
 * @method itemListByParams(array $params) 明细列表
 * @method closeByParams(array $params) 关闭收货单下面的子单
 * @method batchCloseByParams(array $params) 批量关闭收货单
 * @method updateWaitCountByParams(array $params) 更新待收货数量
 * @method importTemplateByParams(array $params) 收货单导入模板
 * @method importByParams(array $params) 导入待收货数量
 * @method receiveByParams(array $params) 批量收货
 * @method batchReceiveByParams(array $params) 批量整单收货
 * @method getCreateByInfosByParams(array $params) 获取创建人s
 * @method getItemLogByParams(array $params) 获取日志信息
 * @method receiveListByParams(array $params) 门店供应链 自用收货单列表
 * @method exportByParams(array $params) 收货单子单导出
 * @method getLogisticsBySkuIdByParams(array $params) sku查询未收获物流单号
 */
class Receive {
    private static string $serviceName = "ProjectSupplyChain";

    private static string $className = "Receive";

    /**
     * 列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function list (int $source) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["source" => $source]);
    }

    /**
     * 收货单详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function detail (int $receiveId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["receiveId" => $receiveId]);
    }

    /**
     * 明细列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function itemList (int $receiveId, int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->itemList(["receiveId" => $receiveId, "page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 关闭收货单下面的子单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function close (int $receiveId, array $items) {
        return RpcClass::getClass(self::$serviceName, self::$className)->close(["receiveId" => $receiveId, "items" => $items]);
    }

    /**
     * 批量关闭收货单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function batchClose (array $receiveIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchClose(["receiveIds" => $receiveIds]);
    }

    /**
     * 更新待收货数量
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function updateWaitCount (array $data) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateWaitCount(["data" => $data]);
    }

    /**
     * 收货单导入模板
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function importTemplate (array $receiveIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->importTemplate(["receiveIds" => $receiveIds]);
    }

    /**
     * 导入待收货数量
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function import (array $data) {
        return RpcClass::getClass(self::$serviceName, self::$className)->import(["data" => $data]);
    }

    /**
     * 批量收货
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function receive (array $data) {
        return RpcClass::getClass(self::$serviceName, self::$className)->receive(["data" => $data]);
    }

    /**
     * 批量整单收货
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function batchReceive (array $receiveIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchReceive(["receiveIds" => $receiveIds]);
    }

    /**
     * 获取创建人s
     * @return  mixed
    */
    public static function getCreateByInfos () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCreateByInfos();
    }

    /**
     * 获取日志信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getItemLog (int $entityId, int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getItemLog(["entityId" => $entityId, "page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 门店供应链 自用收货单列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function receiveList (int $page, int $pageSize) {
        return RpcClass::getClass(self::$serviceName, self::$className)->receiveList(["page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 收货单子单导出
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  string
    */
    public static function export (string $template_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->export(["template_id" => $template_id]);
    }

    /**
     * sku查询未收获物流单号
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getLogisticsBySkuId (int $source) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getLogisticsBySkuId(["source" => $source]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}