<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-08-09 15:45:45
 */
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class PurchaseShipNotice
 * @method listByParams(array $params) 列表
 * @method detailByParams(array $params) 详情
 * @method itemListByParams(array $params) 明细列表
 * @method importTemplateByParams(array $params) 发货通知单导入模板
 * @method importByParams(array $params) 导入快递单号和数量
 * @method importTrackingNumberByParams(array $params) 导入快递单号
 * @method batchFullCloseByParams(array $params) 批量关闭发货主单
 * @method batchSendByParams(array $params) 批量发运
 * @method batchUpdateByParams(array $params) 批量更新
 * @method batchCloseByParams(array $params) 批量关闭
 * @method getCreateByInfosByParams(array $params) 获取创建人s
 * @method getItemLogByParams(array $params) 获取日志信息
 * @method expeditedByParams(array $params) 发货单-加急
 * @method noticeSendTimesByParams(array $params) 获取发货通知单所有的发货时间
 * @method batchPushByParams(array $params) 发货通知单推送
 */
class PurchaseShipNotice {
    private static string $serviceName = "ProjectSupplyChain";

    private static string $className = "PurchaseShipNotice";

    /**
     * 列表
     * @return  array
    */
    public static function list (?\Mainto\Bridge\Structs\ProjectSupplyChain\ShipNotice\CMD\BMSShipNoticeSearchCMD $bMSShipNoticeSearchCMD = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list($bMSShipNoticeSearchCMD);
    }

    /**
     * 详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\ProjectSupplyChain\ShipNotice\DTO\NoticeDetailDTO
    */
    public static function detail () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->detail([]),
            "\Mainto\Bridge\Structs\ProjectSupplyChain\ShipNotice\DTO\NoticeDetailDTO"
        );
    }

    /**
     * 明细列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function itemList (int $noticeId, int $page = 1, int $pageSize = 20, string $skuName = '', string $skuCode = '') {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->itemList(["noticeId" => $noticeId, "page" => $page, "pageSize" => $pageSize, "skuName" => $skuName, "skuCode" => $skuCode]),
            "\Mainto\Bridge\Structs\ProjectSupplyChain\ShipNotice\DTO\ShipNoticeItemDTO[]"
        );
    }

    /**
     * 发货通知单导入模板
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function importTemplate (array $noticeIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->importTemplate(["noticeIds" => $noticeIds]);
    }

    /**
     * 导入快递单号和数量
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function import (array $data) {
        return RpcClass::getClass(self::$serviceName, self::$className)->import(["data" => $data]);
    }

    /**
     * 导入快递单号
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function importTrackingNumber (array $data) {
        return RpcClass::getClass(self::$serviceName, self::$className)->importTrackingNumber(["data" => $data]);
    }

    /**
     * 批量关闭发货主单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\ProjectSupplyChain\Basic\DTO\ErrDTO
    */
    public static function batchFullClose (array $noticeIds, bool $check = true) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->batchFullClose(["noticeIds" => $noticeIds, "check" => $check]),
            "\Mainto\Bridge\Structs\ProjectSupplyChain\Basic\DTO\ErrDTO"
        );
    }

    /**
     * 批量发运
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function batchSend (array $noticeIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchSend(["noticeIds" => $noticeIds]);
    }

    /**
     * 批量更新
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function batchUpdate (array $data) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchUpdate(["data" => $data]);
    }

    /**
     * 批量关闭
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function batchClose (array $data, bool $check = true) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchClose(["data" => $data, "check" => $check]);
    }

    /**
     * 获取创建人s
     * @return  mixed
    */
    public static function getCreateByInfos () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCreateByInfos();
    }

    /**
     * 获取日志信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getItemLog (int $entityId, int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getItemLog(["entityId" => $entityId, "page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 发货单-加急
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function expedited () {
        return RpcClass::getClass(self::$serviceName, self::$className)->expedited([]);
    }

    /**
     * 获取发货通知单所有的发货时间
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function noticeSendTimes (int $noticeId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->noticeSendTimes(["noticeId" => $noticeId]),
            "\Mainto\Bridge\Structs\ProjectSupplyChain\ShipNotice\DTO\ShipArriveStateItemDTO[]"
        );
    }

    /**
     * 发货通知单推送
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function batchPush (array $noticeIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchPush(["noticeIds" => $noticeIds]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}