<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-08-09 15:45:45
 */
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class ExpressDeliveries
 * @method searchExpressDeliveriesByParams(array $params) 查询基础快递单号
 * @method getExpressMapByParams(array $params) 查询基础快递物流MAP
 * @method batchUpdateByParams(array $params) 批量导入（excel导入更新)
 * @method updateByParams(array $params) 单个更新（在收货单中批量更新)
 */
class ExpressDeliveries {
    private static string $serviceName = "ProjectSupplyChain";

    private static string $className = "ExpressDeliveries";

    /**
     * 查询基础快递单号
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function searchExpressDeliveries () {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchExpressDeliveries([]);
    }

    /**
     * 查询基础快递物流MAP
     * @return  mixed
    */
    public static function getExpressMap () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getExpressMap();
    }

    /**
     * 批量导入（excel导入更新)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function batchUpdate () {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchUpdate([]);
    }

    /**
     * 单个更新（在收货单中批量更新)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function update (string $expressType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(["expressType" => $expressType]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}