<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-08-09 15:45:45
 */
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Bms;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class RetailMaterial
 * @method getSupplyChainStaffsByParams(array $params) 获取采购员列表
 * @method bomProductlistByParams(array $params) 获取bom商品列表
 * @method detailByParams(array $params) 获取物料详情
 * @method disableSkuByParams(array $params) 停用sku
 * @method enableSkuByParams(array $params) 恢复sku
 * @method batchImportByParams(array $params) 批量导入物料信息
 * @method newTaskByParams(array $params) 新增导出任务
 * @method getBaseInfoBySkuNameByParams(array $params) bom创建选择sku使用
 * @method getSkusByNameByParams(array $params) 根据物料名称获取对应的sku信息
 * @method getMaterialsByNameByParams(array $params) 根据物料名称获取对应的信息(bom列表搜索条件)
 * @method getMaterialByNameByParams(array $params) getMaterialByName
 * @method getRetailOrSelfMaterialByNameByParams(array $params) 根据物料名称获取对应的信息(bom列表搜索条件)
 */
class RetailMaterial {
    private static string $serviceName = "ProjectSupplyChain";

    private static string $className = "Bms\\RetailMaterial";

    /**
     * 获取采购员列表
     * @return  mixed
    */
    public static function getSupplyChainStaffs () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSupplyChainStaffs();
    }

    /**
     * 获取bom商品列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function bomProductlist (int $page = 1, int $pageSize = 10, int $source = 3) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bomProductlist(["page" => $page, "pageSize" => $pageSize, "source" => $source]);
    }

    /**
     * 获取物料详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]);
    }

    /**
     * 停用sku
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function disableSku (int $skuId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->disableSku(["skuId" => $skuId]);
    }

    /**
     * 恢复sku
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function enableSku (int $skuId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->enableSku(["skuId" => $skuId]);
    }

    /**
     * 批量导入物料信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function batchImport (array $data) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchImport(["data" => $data]);
    }

    /**
     * 新增导出任务
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  string
    */
    public static function newTask (string $template_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->newTask(["template_id" => $template_id]);
    }

    /**
     * bom创建选择sku使用
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getBaseInfoBySkuName (string $skuName, int $source = 3) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getBaseInfoBySkuName(["skuName" => $skuName, "source" => $source]);
    }

    /**
     * 根据物料名称获取对应的sku信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getSkusByName (string $name, int $source = 3) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSkusByName(["name" => $name, "source" => $source]);
    }

    /**
     * 根据物料名称获取对应的信息(bom列表搜索条件)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getMaterialsByName (string $name, int $source = 3) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMaterialsByName(["name" => $name, "source" => $source]);
    }

    /**
     * getMaterialByName
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getMaterialByName (string $name, array $source = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMaterialByName(["name" => $name, "source" => $source]);
    }

    /**
     * 根据物料名称获取对应的信息(bom列表搜索条件)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getRetailOrSelfMaterialByName (string $name, array $source = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRetailOrSelfMaterialByName(["name" => $name, "source" => $source]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}