<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-09 17:22:59
 */
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Supplier;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class SupplierPurchaseShipNotice
 * @method redPointByParams(array $params) 供应商协同-红点查看获取已逾期+加急的 发货单据数量
 * @method getShopCountByParams(array $params) 供应商协同-门店数
 * @method batchSendByParams(array $params) 批量发运
 * @method supplySystemItemListByParams(array $params) 供应商协同-采购发货单-列表
 * @method supplySystemItemListHistoryByParams(array $params) 供应商协同-采购发货单-历史列表
 * @method searchSupplySystemMaterialByParams(array $params) 供应商协同-供应商物料-物料搜索
 * @method getAllStorageByParams(array $params) 获取所有仓库
 * @method supplySessionTestByParams(array $params) 功能测试
 * @method supplyNoticePredictByParams(array $params) supplyNoticePredict
 */
class SupplierPurchaseShipNotice {
    private static string $serviceName = "ProjectSupplyChain";

    private static string $className = "Supplier\\SupplierPurchaseShipNotice";

    /**
     * 供应商协同-红点查看获取已逾期+加急的 发货单据数量
     * @return  int
    */
    public static function redPoint () {
        return RpcClass::getClass(self::$serviceName, self::$className)->redPoint();
    }

    /**
     * 供应商协同-门店数
     * @return  array
    */
    public static function getShopCount () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getShopCount();
    }

    /**
     * 批量发运
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function batchSend () {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchSend([]);
    }

    /**
     * 供应商协同-采购发货单-列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function supplySystemItemList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->supplySystemItemList([]);
    }

    /**
     * 供应商协同-采购发货单-历史列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function supplySystemItemListHistory () {
        return RpcClass::getClass(self::$serviceName, self::$className)->supplySystemItemListHistory([]);
    }

    /**
     * 供应商协同-供应商物料-物料搜索
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function searchSupplySystemMaterial (int $source) {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchSupplySystemMaterial(["source" => $source]);
    }

    /**
     * 获取所有仓库
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getAllStorage () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllStorage([]);
    }

    /**
     * 功能测试
     * @return  mixed
    */
    public static function supplySessionTest () {
        return RpcClass::getClass(self::$serviceName, self::$className)->supplySessionTest();
    }

    /**
     * supplyNoticePredict
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function supplyNoticePredict (int $fromStorageId, int $toStorageId, string $arriveDate = '') {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->supplyNoticePredict(["fromStorageId" => $fromStorageId, "toStorageId" => $toStorageId, "arriveDate" => $arriveDate]),
            "\Mainto\Bridge\Structs\ProjectSupplyChain\ShipNotice\DTO\NoticeItemPredictDTO[]"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}