<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-09 17:22:59
 */
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Store;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class SelfStock
 * @method stockFlowListByParams(array $params) 出入库记录-出入库记录
 * @method stockFlowListExportByParams(array $params) 出入库记录-出入库记录导出（门店端自用库存导出)
 * @method stockFlowDetailByParams(array $params) 出入库记录-出入库详情
 * @method stockFlowDetailItemListByParams(array $params) 出入库记录-出入库详情-出入库明细
 * @method exportAddByParams(array $params) 库存-导出查询结果
 * @method stockFlowItemListByParams(array $params) 库存-库存明细(库存子表维度：stock_flow_item)
 * @method stockCollectOutByParams(array $params) 库存-领用出库
 * @method exportSelfStockByParams(array $params) [门店自用库存导出]
 * @method exportSelfStockSkuLiveByParams(array $params) [门店自用库存生命周期导出]
 * @method getStorageServiceByParams(array $params) getStorageService
 */
class SelfStock {
    private static string $serviceName = "ProjectSupplyChain";

    private static string $className = "Store\\SelfStock";

    /**
     * 出入库记录-出入库记录
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function stockFlowList (int $page, int $pageSize) {
        return RpcClass::getClass(self::$serviceName, self::$className)->stockFlowList(["page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 出入库记录-出入库记录导出（门店端自用库存导出)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  string
    */
    public static function stockFlowListExport (string $template_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->stockFlowListExport(["template_id" => $template_id]);
    }

    /**
     * 出入库记录-出入库详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function stockFlowDetail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->stockFlowDetail(["id" => $id]);
    }

    /**
     * 出入库记录-出入库详情-出入库明细
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function stockFlowDetailItemList (int $stockFlowId, int $page, int $pageSize) {
        return RpcClass::getClass(self::$serviceName, self::$className)->stockFlowDetailItemList(["stockFlowId" => $stockFlowId, "page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 库存-导出查询结果
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  string
    */
    public static function exportAdd (string $template_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->exportAdd(["template_id" => $template_id]);
    }

    /**
     * 库存-库存明细(库存子表维度：stock_flow_item)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function stockFlowItemList (int $skuId, int $page, int $pageSize) {
        return RpcClass::getClass(self::$serviceName, self::$className)->stockFlowItemList(["skuId" => $skuId, "page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 库存-领用出库
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function stockCollectOut (string $fromType, array $itemList) {
        return RpcClass::getClass(self::$serviceName, self::$className)->stockCollectOut(["fromType" => $fromType, "itemList" => $itemList]);
    }

    /**
     * [门店自用库存导出]
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  string
    */
    public static function exportSelfStock (string $template_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->exportSelfStock(["template_id" => $template_id]);
    }

    /**
     * [门店自用库存生命周期导出]
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  string
    */
    public static function exportSelfStockSkuLive (string $template_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->exportSelfStockSkuLive(["template_id" => $template_id]);
    }

    /**
     * getStorageService
     * @return  mixed
    */
    public static function getStorageService () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStorageService();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}