<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-09 17:22:59
 */
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Store;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class RetailInventory
 * @method listByParams(array $params) 库存盘点列表
 * @method getSkuInInventoryByParams(array $params) 盘点包含SKU内容
 * @method detailByParams(array $params) 盘点详情
 * @method saveByParams(array $params) 保存盘点
 * @method addByParams(array $params) 新增盘点
 * @method noticeByParams(array $params) 盘点提醒
 * @method getStockBySkuIdsByParams(array $params) 根据门店和sku获取库存
 * @method getAllSkuInStoreByParams(array $params) 获取门店所有商品和库存
 */
class RetailInventory {
    private static string $serviceName = "ProjectSupplyChain";

    private static string $className = "Store\\RetailInventory";

    /**
     * 库存盘点列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function list (int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 盘点包含SKU内容
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getSkuInInventory (int $inventoryId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSkuInInventory(["inventoryId" => $inventoryId]);
    }

    /**
     * 盘点详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function detail (int $inventoryId, int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["inventoryId" => $inventoryId, "page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 保存盘点
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function save (int $inventoryId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->save(["inventoryId" => $inventoryId]);
    }

    /**
     * 新增盘点
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function add () {
        return RpcClass::getClass(self::$serviceName, self::$className)->add([]);
    }

    /**
     * 盘点提醒
     * @return  array
    */
    public static function notice () {
        return RpcClass::getClass(self::$serviceName, self::$className)->notice();
    }

    /**
     * 根据门店和sku获取库存
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getStockBySkuIds (array $skuIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStockBySkuIds(["skuIds" => $skuIds]);
    }

    /**
     * 获取门店所有商品和库存
     * @return  array
    */
    public static function getAllSkuInStore () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllSkuInStore();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}