<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-09 17:22:59
 */
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class PurchaseEntry
 * @method createByParams(array $params) 创建入库单
 * @method getItemsByParams(array $params) 获取入库单子单
 * @method getListPaginationByParams(array $params) 分页查询入库单列表
 * @method getListByParams(array $params) 退款单列表不分页
 * @method approvalRevokeByParams(array $params) 撤回审批
 * @method closePurchaseEntryByParams(array $params) 订单关闭
 * @method updateEntryByParams(array $params) 订单更新
 * @method purchaseEntryEnumsByParams(array $params) 枚举
 */
class PurchaseEntry {
    private static string $serviceName = "ProjectSupplyChain";

    private static string $className = "PurchaseEntry";

    /**
     * 创建入库单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function create (array $items) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["items" => $items]);
    }

    /**
     * 获取入库单子单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getItems (int $entryId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getItems(["entryId" => $entryId]);
    }

    /**
     * 分页查询入库单列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getListPagination (int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getListPagination(["page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 退款单列表不分页
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getList([]);
    }

    /**
     * 撤回审批
     * @return  bool
    */
    public static function approvalRevoke (\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseEntry\CMD\PurchaseEntryApprovalRevokeReq $purchaseEntryApprovalRevokeReq) {
        return RpcClass::getClass(self::$serviceName, self::$className)->approvalRevoke($purchaseEntryApprovalRevokeReq);
    }

    /**
     * 订单关闭
     * @return  bool
    */
    public static function closePurchaseEntry (\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseEntry\CMD\PurchaseEntryCloseReq $purchaseEntryCloseReq) {
        return RpcClass::getClass(self::$serviceName, self::$className)->closePurchaseEntry($purchaseEntryCloseReq);
    }

    /**
     * 订单更新
     * @return  bool
    */
    public static function updateEntry (\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseEntry\CMD\PurchaseEntryUpdateReq $purchaseEntryUpdateReq) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateEntry($purchaseEntryUpdateReq);
    }

    /**
     * 枚举
     * @return  array
    */
    public static function purchaseEntryEnums () {
        return RpcClass::getClass(self::$serviceName, self::$className)->purchaseEntryEnums();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}