<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-09 17:22:59
 */
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Logistic
 * @method getLogisticDetailByParams(array $params) 根据物流单号查询物流信息
 * @method getStoreOnlineCountByParams(array $params) 获取门店在途物流单数量
 * @method getStoreOnlineListByParams(array $params) 获取门店在途物流单列表
 * @method getExpressDeliveriesDetailByParams(array $params) 根据物流单号查询物流单详情
 */
class Logistic {
    private static string $serviceName = "ProjectSupplyChain";

    private static string $className = "Logistic";

    /**
     * 根据物流单号查询物流信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getLogisticDetail (string $logisticsNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getLogisticDetail(["logisticsNo" => $logisticsNo]);
    }

    /**
     * 获取门店在途物流单数量
     * @return  int
    */
    public static function getStoreOnlineCount () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreOnlineCount();
    }

    /**
     * 获取门店在途物流单列表
     * @return  array
    */
    public static function getStoreOnlineList (?\Mainto\Bridge\Structs\ProjectSupplyChain\Logistic\CMD\LogisticSearchCmd $logisticSearchCmd = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreOnlineList($logisticSearchCmd);
    }

    /**
     * 根据物流单号查询物流单详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getExpressDeliveriesDetail (string $logisticsNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getExpressDeliveriesDetail(["logisticsNo" => $logisticsNo]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}