<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-09 17:22:59
 */
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class BmsMaterial
 * @method getMaterialListByParams(array $params) 获取物料列表(根据自用属性查询)
 * @method getMaterialByParams(array $params) 获取物料采买sku详情
 * @method createByParams(array $params) 创建需求单
 * @method getDemandListByParams(array $params) 需求单列表
 * @method detailByParams(array $params) 需求单详情
 * @method newTaskByParams(array $params) 新增导出任务
 * @method listByParams(array $params) bms自用收货单列表
 * @method getBomProductsByParams(array $params) bom商品列表(bom编码和名称的获取) 自用
 * @method stockListByParams(array $params) bms 职能采购库存列表
 * @method exportAddByParams(array $params) bms 职能采购 库存-导出查询结果
 * @method stockCollectOutByParams(array $params) bms 职能采购 库存-领用出库
 * @method stockFlowItemListByParams(array $params) bms 职能采购 库存-库存明细(库存子表维度：stock_flow_item)
 * @method batchReceiveShipByParams(array $params) bms自用收货操作-批量收货
 * @method getStorageServiceByParams(array $params) getStorageService
 * @method getStoragesByStaffIdByParams(array $params) 获取员工对应的一级部门和对应的仓库，一对多关系
 * @method updateReceiveAddressByParams(array $params) 根据id获取或新建新的receiveAddressLog
 * @method getDepartmentsByStaffIdByParams(array $params) 获取员工对应的多部门
 * @method getRetailMaterialTemplateByParams(array $params) 零售需求单物料批量导入模版
 */
class BmsMaterial {
    private static string $serviceName = "ProjectSupplyChain";

    private static string $className = "BmsMaterial";

    /**
     * 获取物料列表(根据自用属性查询)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getMaterialList (int $page, int $pageSize) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMaterialList(["page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 获取物料采买sku详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getMaterial (string $code) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMaterial(["code" => $code]);
    }

    /**
     * 创建需求单
     * @return  mixed
    */
    public static function create (\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseDemand\CMD\SelfPurchaseDemandAddCMD $selfPurchaseDemandAddCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create($selfPurchaseDemandAddCMD);
    }

    /**
     * 需求单列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getDemandList (int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getDemandList(["page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 需求单详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]);
    }

    /**
     * 新增导出任务
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  string
    */
    public static function newTask (string $template_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->newTask(["template_id" => $template_id]);
    }

    /**
     * bms自用收货单列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function list (int $page, int $pageSize) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * bom商品列表(bom编码和名称的获取) 自用
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getBomProducts () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getBomProducts([]);
    }

    /**
     * bms 职能采购库存列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function stockList (int $page, int $departmentId, int $pageSize) {
        return RpcClass::getClass(self::$serviceName, self::$className)->stockList(["page" => $page, "departmentId" => $departmentId, "pageSize" => $pageSize]);
    }

    /**
     * bms 职能采购 库存-导出查询结果
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  string
    */
    public static function exportAdd (string $template_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->exportAdd(["template_id" => $template_id]);
    }

    /**
     * bms 职能采购 库存-领用出库
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function stockCollectOut (string $fromType, array $itemList) {
        return RpcClass::getClass(self::$serviceName, self::$className)->stockCollectOut(["fromType" => $fromType, "itemList" => $itemList]);
    }

    /**
     * bms 职能采购 库存-库存明细(库存子表维度：stock_flow_item)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function stockFlowItemList (int $skuId, int $page, int $storageId, int $pageSize) {
        return RpcClass::getClass(self::$serviceName, self::$className)->stockFlowItemList(["skuId" => $skuId, "page" => $page, "storageId" => $storageId, "pageSize" => $pageSize]);
    }

    /**
     * bms自用收货操作-批量收货
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function batchReceiveShip (array $data) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchReceiveShip(["data" => $data]);
    }

    /**
     * getStorageService
     * @return  mixed
    */
    public static function getStorageService () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStorageService();
    }

    /**
     * 获取员工对应的一级部门和对应的仓库，一对多关系
     * @return  array
    */
    public static function getStoragesByStaffId () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoragesByStaffId();
    }

    /**
     * 根据id获取或新建新的receiveAddressLog
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function updateReceiveAddress (string $province, string $city, string $area, string $address) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateReceiveAddress(["province" => $province, "city" => $city, "area" => $area, "address" => $address]);
    }

    /**
     * 获取员工对应的多部门
     * @return  array
    */
    public static function getDepartmentsByStaffId () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getDepartmentsByStaffId();
    }

    /**
     * 零售需求单物料批量导入模版
     * @return  array
    */
    public static function getRetailMaterialTemplate (?\Mainto\Bridge\Structs\ProjectSupplyChain\Material\Cmd\SearchCmd $searchCmd = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRetailMaterialTemplate($searchCmd);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}