<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-09 17:22:59
 */
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Bms;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class RetailPurchaseOrder
 * @method createOrderByParams(array $params) 创建零售半成品采购单
 * @method listByParams(array $params) 列表
 * @method detailByParams(array $params) 详情
 * @method itemListByParams(array $params) 明细列表
 * @method updateByParams(array $params) 更新
 * @method submitByParams(array $params) 提交(生成发货通知单)
 * @method createApproveByParams(array $params) 发起审批
 * @method callbackDingProcessByParams(array $params) 钉钉审批回调
 * @method closeByParams(array $params) 关闭
 * @method updateOrderItemByParams(array $params) 修改明细信息(预付款前)
 * @method updateCostPriceByParams(array $params) 更新采购价(预付款后)
 * @method getRetailPartMaterialTemplateByParams(array $params) 零售半成品采购单物料批量导入模版
 */
class RetailPurchaseOrder {
    private static string $serviceName = "ProjectSupplyChain";

    private static string $className = "Bms\\RetailPurchaseOrder";

    /**
     * 创建零售半成品采购单
     * @return  bool
    */
    public static function createOrder (\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseOrder\CMD\CreateAddCMD $createAddCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createOrder($createAddCMD);
    }

    /**
     * 列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function list (int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function detail () {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail([]);
    }

    /**
     * 明细列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function itemList (int $orderId, int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->itemList(["orderId" => $orderId, "page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 更新
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function update (int $orderId, int $supplierId, string $remark = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(["orderId" => $orderId, "supplierId" => $supplierId, "remark" => $remark]);
    }

    /**
     * 提交(生成发货通知单)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function submit (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->submit(["orderId" => $orderId]);
    }

    /**
     * 发起审批
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function createApprove (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createApprove(["orderId" => $orderId]);
    }

    /**
     * 钉钉审批回调
     * @return  string
    */
    public static function callbackDingProcess () {
        return RpcClass::getClass(self::$serviceName, self::$className)->callbackDingProcess();
    }

    /**
     * 关闭
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function close (int $orderId, array $orderItemIds, int $closeCount) {
        return RpcClass::getClass(self::$serviceName, self::$className)->close(["orderId" => $orderId, "orderItemIds" => $orderItemIds, "closeCount" => $closeCount]);
    }

    /**
     * 修改明细信息(预付款前)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function updateOrderItem (array $data) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateOrderItem(["data" => $data]);
    }

    /**
     * 更新采购价(预付款后)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function updateCostPrice (array $data) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateCostPrice(["data" => $data]);
    }

    /**
     * 零售半成品采购单物料批量导入模版
     * @return  array
    */
    public static function getRetailPartMaterialTemplate (?\Mainto\Bridge\Structs\ProjectSupplyChain\Material\Cmd\SearchCmd $searchCmd = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRetailPartMaterialTemplate($searchCmd);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}