<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-13 16:21:18
 */
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Store;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class SelfAllocation
 * @method waitDeliverNumberByParams(array $params) 待处理调拨单数量
 * @method listByParams(array $params) 门店调拨单列表
 * @method createByParams(array $params) 新增调拨并创建收货单
 * @method searchMaterialByParams(array $params) 搜索物料-库存表搜
 * @method getStorageServiceByParams(array $params) getStorageService
 */
class SelfAllocation {
    private static string $serviceName = "ProjectSupplyChain";

    private static string $className = "Store\\SelfAllocation";

    /**
     * 待处理调拨单数量
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function waitDeliverNumber (int $source) {
        return RpcClass::getClass(self::$serviceName, self::$className)->waitDeliverNumber(["source" => $source]);
    }

    /**
     * 门店调拨单列表
     * @return  array
    */
    public static function list (?\Mainto\Bridge\Structs\ProjectSupplyChain\Allocation\CMD\AllocationPaginateSearchCMD $allocationPaginateSearchCMD = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list($allocationPaginateSearchCMD);
    }

    /**
     * 新增调拨并创建收货单
     * @return  \Mainto\Bridge\Structs\ProjectSupplyChain\Basic\DTO\CheckPassDTO
    */
    public static function create (\Mainto\Bridge\Structs\ProjectSupplyChain\Allocation\CMD\AllocationAddCMD $allocationAddCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->create($allocationAddCMD),
            "\Mainto\Bridge\Structs\ProjectSupplyChain\Basic\DTO\CheckPassDTO"
        );
    }

    /**
     * 搜索物料-库存表搜
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function searchMaterial (string $keyword) {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchMaterial(["keyword" => $keyword]);
    }

    /**
     * getStorageService
     * @return  mixed
    */
    public static function getStorageService () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStorageService();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}