<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-13 16:21:18
 */
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Storage
 * @method getStoragesByParams(array $params) 获取仓库s
 * @method getStorageByStoreIdByParams(array $params) 根据门店获取对应仓库
 * @method storageListByParams(array $params) 获取仓库列表
 * @method createStorageByStoreByParams(array $params) 创建门店仓库
 * @method createStorageBySupplierByParams(array $params) 创建供应商仓库
 * @method getAllStorageByParams(array $params) 获取所有仓库
 * @method getStorageAddressByParams(array $params) 获取仓库地址
 * @method getListPageByParams(array $params) 获取所有仓库
 * @method getInfoByParams(array $params) 仓库详情
 * @method saveStorageInfoByParams(array $params) 修改仓库信息
 * @method openStoragePushWmsByParams(array $params) 设置仓库开启对接巨沃
 * @method endStoragePushWmsByParams(array $params) 关闭仓库开启对接巨沃
 * @method getWmsCodeByParams(array $params) 获取巨沃仓配置信息
 * @method getBMSNotOperateStorageByParams(array $params) 获取bms不可操作的仓库列表
 * @method getBMSNotShipStorageByParams(array $params) 获取bms不可操作的仓库列表
 * @method getStorageFilterBlockByParams(array $params) 获取仓库的黑白物流名单
 * @method addStorageFilterBlockByParams(array $params) 增加仓库物流
 */
class Storage {
    private static string $serviceName = "ProjectSupplyChain";

    private static string $className = "Storage";

    /**
     * 获取仓库s
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getStorages () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStorages([]);
    }

    /**
     * 根据门店获取对应仓库
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getStorageByStoreId (int $storeId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStorageByStoreId(["storeId" => $storeId]);
    }

    /**
     * 获取仓库列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function storageList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->storageList([]);
    }

    /**
     * 创建门店仓库
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function createStorageByStore (int $id, string $name, array $extend = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createStorageByStore(["id" => $id, "name" => $name, "extend" => $extend]);
    }

    /**
     * 创建供应商仓库
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function createStorageBySupplier (int $id, string $name, array $extend) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createStorageBySupplier(["id" => $id, "name" => $name, "extend" => $extend]);
    }

    /**
     * 获取所有仓库
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getAllStorage () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllStorage([]);
    }

    /**
     * 获取仓库地址
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getStorageAddress (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStorageAddress(["id" => $id]);
    }

    /**
     * 获取所有仓库
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getListPage () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getListPage([]);
    }

    /**
     * 仓库详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getInfo () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getInfo([]);
    }

    /**
     * 修改仓库信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function saveStorageInfo (int $id, string $province, string $city, string $area, string $address, string $userName, string $phone) {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveStorageInfo(["id" => $id, "province" => $province, "city" => $city, "area" => $area, "address" => $address, "userName" => $userName, "phone" => $phone]);
    }

    /**
     * 设置仓库开启对接巨沃
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function openStoragePushWms (int $storageId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->openStoragePushWms(["storageId" => $storageId]);
    }

    /**
     * 关闭仓库开启对接巨沃
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function endStoragePushWms (int $storageId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->endStoragePushWms(["storageId" => $storageId]);
    }

    /**
     * 获取巨沃仓配置信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getWmsCode (int $storageId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getWmsCode(["storageId" => $storageId]);
    }

    /**
     * 获取bms不可操作的仓库列表
     * @return  mixed
    */
    public static function getBMSNotOperateStorage () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getBMSNotOperateStorage();
    }

    /**
     * 获取bms不可操作的仓库列表
     * @return  mixed
    */
    public static function getBMSNotShipStorage () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getBMSNotShipStorage();
    }

    /**
     * 获取仓库的黑白物流名单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getStorageFilterBlock (int $storageId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStorageFilterBlock(["storageId" => $storageId]);
    }

    /**
     * 增加仓库物流
     * @return  array
    */
    public static function addStorageFilterBlock (\Mainto\Bridge\Structs\ProjectSupplyChain\Storage\CMD\StorageFilterBatchCreateCMD $storageFilterBatchCreateCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addStorageFilterBlock($storageFilterBatchCreateCMD);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}