<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-13 16:21:18
 */
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class PurchaseDemand
 * @method isDemandTimeOrNotByParams(array $params) 是否是需求单时间
 * @method autoUpdatePurchaseCountLimitByParams(array $params) 每个月自动更新门店物料的剩余采购数量
 * @method getDemandListByParams(array $params) 需求单列表
 * @method getDemandAndSkuListByParams(array $params) 供应链助手采购申请
 * @method searchDemandBySkuIdByParams(array $params) 供应链助手采购申请-按物料搜
 * @method detailByParams(array $params) 需求单详情
 * @method detailAndSkuByParams(array $params) 供应链助手需求单详情
 * @method callbackDingProcessByParams(array $params) 钉钉审批回调
 * @method createByParams(array $params) 创建需求单
 * @method resendApproveByParams(array $params) 重新发起需求单审批
 * @method batchDealByParams(array $params) 批量处理
 * @method batchCloseByParams(array $params) 批量关闭
 * @method itemListByParams(array $params) 明细列表
 * @method updateCountLimitByParams(array $params) 更新采购上限数量
 * @method purchaseDemandBatchCloseNoticeByParams(array $params) 需求单关闭发送玎钉通知
 * @method getDemandTypeListByParams(array $params) 获取采买类型列表
 * @method purchaseForecastByParams(array $params) 采购预测
 * @method unsetPurchaseForecastByParams(array $params) 失效预测
 * @method getDemandCountLimitByParams(array $params) 获取门店下单需求限制
 * @method createDemandOrderTypeByParams(array $params) 门店申请采购申请原因
 */
class PurchaseDemand {
    private static string $serviceName = "ProjectSupplyChain";

    private static string $className = "PurchaseDemand";

    /**
     * 是否是需求单时间
     * @return  bool
    */
    public static function isDemandTimeOrNot () {
        return RpcClass::getClass(self::$serviceName, self::$className)->isDemandTimeOrNot();
    }

    /**
     * 每个月自动更新门店物料的剩余采购数量
     * @return  int
    */
    public static function autoUpdatePurchaseCountLimit () {
        return RpcClass::getClass(self::$serviceName, self::$className)->autoUpdatePurchaseCountLimit();
    }

    /**
     * 需求单列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getDemandList (int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getDemandList(["page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 供应链助手采购申请
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getDemandAndSkuList (int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getDemandAndSkuList(["page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 供应链助手采购申请-按物料搜
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function searchDemandBySkuId () {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchDemandBySkuId([]);
    }

    /**
     * 需求单详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]);
    }

    /**
     * 供应链助手需求单详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function detailAndSku (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detailAndSku(["id" => $id]);
    }

    /**
     * 钉钉审批回调
     * @return  string
    */
    public static function callbackDingProcess () {
        return RpcClass::getClass(self::$serviceName, self::$className)->callbackDingProcess();
    }

    /**
     * 创建需求单
     * @return  mixed
    */
    public static function create (\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseDemand\CMD\StorePurchaseDemandAddCMD $storePurchaseDemandAddCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create($storePurchaseDemandAddCMD);
    }

    /**
     * 重新发起需求单审批
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function resendApprove (array $demandIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->resendApprove(["demandIds" => $demandIds]);
    }

    /**
     * 批量处理
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function batchDeal (array $demandItemIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchDeal(["demandItemIds" => $demandItemIds]);
    }

    /**
     * 批量关闭
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function batchClose (array $demandItemIds, string $closeReason, int $closeType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchClose(["demandItemIds" => $demandItemIds, "closeReason" => $closeReason, "closeType" => $closeType]);
    }

    /**
     * 明细列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function itemList (int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->itemList(["page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 更新采购上限数量
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function updateCountLimit (array $storeIds, array $details) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateCountLimit(["storeIds" => $storeIds, "details" => $details]);
    }

    /**
     * 需求单关闭发送玎钉通知
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function purchaseDemandBatchCloseNotice (int $staffId, string $content) {
        return RpcClass::getClass(self::$serviceName, self::$className)->purchaseDemandBatchCloseNotice(["staffId" => $staffId, "content" => $content]);
    }

    /**
     * 获取采买类型列表
     * @return  array
    */
    public static function getDemandTypeList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getDemandTypeList();
    }

    /**
     * 采购预测
     * @return  \Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseDemand\DTO\PurchaseForecastListRes
    */
    public static function purchaseForecast () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->purchaseForecast(),
            "\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseDemand\DTO\PurchaseForecastListRes"
        );
    }

    /**
     * 失效预测
     * @return  bool
    */
    public static function unsetPurchaseForecast (\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseDemand\CMD\UnsetPurchaseForecastListReq $unsetPurchaseForecastListReq) {
        return RpcClass::getClass(self::$serviceName, self::$className)->unsetPurchaseForecast($unsetPurchaseForecastListReq);
    }

    /**
     * 获取门店下单需求限制
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getDemandCountLimit (array $skuIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getDemandCountLimit(["skuIds" => $skuIds]);
    }

    /**
     * 门店申请采购申请原因
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function createDemandOrderType (string $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createDemandOrderType(["type" => $type]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}