<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-13 16:21:18
 */
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class ProductTag
 * @method getInfoByParams(array $params) 获取物料标签列表(分页)
 * @method getListByParams(array $params) 获取物料标签列表
 * @method getListTreeBySkuIdByParams(array $params) 获取物料绑定的标签列表（带选中）
 * @method createByParams(array $params) 创建物料标签
 * @method updateByParams(array $params) 编辑物料标签
 * @method bindProductByParams(array $params) 标签绑定的产品
 * @method getProductListByParams(array $params) 获取全部产品
 * @method productStoreTypeByParams(array $params) 门店品牌枚举
 * @method delProductTagByParams(array $params) 删除门店品牌
 * @method newTaskByParams(array $params) 新增导出任务
 * @method getProductByStoreByParams(array $params) 获取门店可用产品标签
 * @method getAllProductTagByParams(array $params) 获取可用产品标签
 */
class ProductTag {
    private static string $serviceName = "ProjectSupplyChain";

    private static string $className = "ProductTag";

    /**
     * 获取物料标签列表(分页)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getInfo (int $page = 1, int $pageSize = 15) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getInfo(["page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 获取物料标签列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getList([]);
    }

    /**
     * 获取物料绑定的标签列表（带选中）
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getListTreeBySkuId (int $skuId, int $isAll = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getListTreeBySkuId(["skuId" => $skuId, "isAll" => $isAll]);
    }

    /**
     * 创建物料标签
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function create () {
        return RpcClass::getClass(self::$serviceName, self::$className)->create([]);
    }

    /**
     * 编辑物料标签
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function update (int $productTagId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(["productTagId" => $productTagId]);
    }

    /**
     * 标签绑定的产品
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function bindProduct (int $productTagId, array $productIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bindProduct(["productTagId" => $productTagId, "productIds" => $productIds]);
    }

    /**
     * 获取全部产品
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getProductList (int $isExport = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductList(["isExport" => $isExport]);
    }

    /**
     * 门店品牌枚举
     * @return  array
    */
    public static function productStoreType () {
        return RpcClass::getClass(self::$serviceName, self::$className)->productStoreType();
    }

    /**
     * 删除门店品牌
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function delProductTag (int $productTagId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delProductTag(["productTagId" => $productTagId]);
    }

    /**
     * 新增导出任务
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  string
    */
    public static function newTask (string $template_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->newTask(["template_id" => $template_id]);
    }

    /**
     * 获取门店可用产品标签
     * @return  array
    */
    public static function getProductByStore () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductByStore();
    }

    /**
     * 获取可用产品标签
     * @return  mixed
    */
    public static function getAllProductTag () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllProductTag();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}