<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-13 16:21:18
 */
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class ProcessOrder
 * @method createdByParams(array $params) 创建加工单
 * @method getPageListByParams(array $params) 加工单分页列表
 * @method detailByParams(array $params) 加工单详情
 * @method getProductSkuTransformByParams(array $params) 获取成品加工组合
 */
class ProcessOrder {
    private static string $serviceName = "ProjectSupplyChain";

    private static string $className = "ProcessOrder";

    /**
     * 创建加工单
     * @return  array
    */
    public static function created (\Mainto\Bridge\Structs\ProjectSupplyChain\ProcessOrder\Cmd\ProcessOrderBatchCreateCmd $processOrderBatchCreateCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->created($processOrderBatchCreateCmd);
    }

    /**
     * 加工单分页列表
     * @return  \Mainto\Bridge\Structs\ProjectSupplyChain\ProcessOrder\DTO\ProcessOrderPageListDTO
    */
    public static function getPageList (\Mainto\Bridge\Structs\ProjectSupplyChain\ProcessOrder\Cmd\ProcessOrderListPageCmd $processOrderListPageCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getPageList($processOrderListPageCmd),
            "\Mainto\Bridge\Structs\ProjectSupplyChain\ProcessOrder\DTO\ProcessOrderPageListDTO"
        );
    }

    /**
     * 加工单详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function detail (int $processOrderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["processOrderId" => $processOrderId]);
    }

    /**
     * 获取成品加工组合
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getProductSkuTransform (array $productSkuIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductSkuTransform(["productSkuIds" => $productSkuIds]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}