<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-13 16:21:18
 */
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Material
 * @method getSupplyChainStaffsByParams(array $params) 获取采购员列表
 * @method listByParams(array $params) 获取物料列表
 * @method detailByParams(array $params) 获取物料详情
 * @method getSkusByMaterialIdByParams(array $params) 根据物料id获取sku信息
 * @method newTaskByParams(array $params) 新增导出任务
 * @method getMaterialSkusByParams(array $params) 获取全量导出物料
 * @method getMaterialByParams(array $params) getMaterial
 * @method getMaterialsByNameByParams(array $params) getMaterialsByName
 * @method doAutoSetNoByParams(array $params) 手动初始化每日单号
 * @method autoSetNoByParams(array $params) 自动初始化物料code
 * @method autoSetSkuCodeByParams(array $params) 自动初始化skucode
 * @method getMaterialByNameByParams(array $params) 下拉远程搜索使用
 * @method getSkuInfoBySkuNameByParams(array $params) sku查询 下拉列表使用
 * @method getSkuSelectBySkuNameByParams(array $params) sku查询 下拉列表使用
 * @method bmsExportAddByParams(array $params) 根据source获取自用物料或者零售商品-创建导出
 * @method storeExportAddByParams(array $params) 根据source获取自用物料或者零售商品-创建导出
 * @method bmsAllocationBatchExportAddByParams(array $params) BMS-批量调拨模板下载
 * @method syncMaterialSkuByParams(array $params) 向ebs同步物料sku
 * @method getAllSelfMaterialByParams(array $params) 获取自用全部物料（包含下架）
 * @method getSkusByMaterialIdsByParams(array $params) 根据物料ids获取sku信息
 * @method searchMaterialByParams(array $params) 查询物料sku信息
 * @method getMaterialSkuListPageByParams(array $params) 获取sku分页列表
 */
class Material {
    private static string $serviceName = "ProjectSupplyChain";

    private static string $className = "Material";

    /**
     * 获取采购员列表
     * @return  mixed
    */
    public static function getSupplyChainStaffs () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSupplyChainStaffs();
    }

    /**
     * 获取物料列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function list (int $page = 1, int $pageSize = 10, int $source = 1, int $status = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["page" => $page, "pageSize" => $pageSize, "source" => $source, "status" => $status]);
    }

    /**
     * 获取物料详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]);
    }

    /**
     * 根据物料id获取sku信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getSkusByMaterialId (int $materialId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSkusByMaterialId(["materialId" => $materialId]);
    }

    /**
     * 新增导出任务
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  string
    */
    public static function newTask (string $template_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->newTask(["template_id" => $template_id]);
    }

    /**
     * 获取全量导出物料
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getMaterialSkus (string $isProcess = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMaterialSkus(["isProcess" => $isProcess]);
    }

    /**
     * getMaterial
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getMaterial (string $code) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMaterial(["code" => $code]);
    }

    /**
     * getMaterialsByName
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getMaterialsByName (string $name, int $isFixedAsset = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMaterialsByName(["name" => $name, "isFixedAsset" => $isFixedAsset]);
    }

    /**
     * 手动初始化每日单号
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  void
    */
    public static function doAutoSetNo (string $date) {
         RpcClass::getClass(self::$serviceName, self::$className)->doAutoSetNo(["date" => $date]);
    }

    /**
     * 自动初始化物料code
     * @return  void
    */
    public static function autoSetNo () {
         RpcClass::getClass(self::$serviceName, self::$className)->autoSetNo();
    }

    /**
     * 自动初始化skucode
     * @return  void
    */
    public static function autoSetSkuCode () {
         RpcClass::getClass(self::$serviceName, self::$className)->autoSetSkuCode();
    }

    /**
     * 下拉远程搜索使用
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getMaterialByName (string $name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMaterialByName(["name" => $name]);
    }

    /**
     * sku查询 下拉列表使用
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getSkuInfoBySkuName (string $skuName, int $source = 1) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSkuInfoBySkuName(["skuName" => $skuName, "source" => $source]);
    }

    /**
     * sku查询 下拉列表使用
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getSkuSelectBySkuName (bool $isExcel = false, bool $isBindTaxes = false, bool $isNotBindCostprice = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSkuSelectBySkuName(["isExcel" => $isExcel, "isBindTaxes" => $isBindTaxes, "isNotBindCostprice" => $isNotBindCostprice]);
    }

    /**
     * 根据source获取自用物料或者零售商品-创建导出
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  string
    */
    public static function bmsExportAdd (string $template_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bmsExportAdd(["template_id" => $template_id]);
    }

    /**
     * 根据source获取自用物料或者零售商品-创建导出
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  string
    */
    public static function storeExportAdd (string $template_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->storeExportAdd(["template_id" => $template_id]);
    }

    /**
     * BMS-批量调拨模板下载
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  string
    */
    public static function bmsAllocationBatchExportAdd (string $template_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bmsAllocationBatchExportAdd(["template_id" => $template_id]);
    }

    /**
     * 向ebs同步物料sku
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function syncMaterialSku (array $materialIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->syncMaterialSku(["materialIds" => $materialIds]);
    }

    /**
     * 获取自用全部物料（包含下架）
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getAllSelfMaterial (int $page = 1, int $pageSize = 10, int $isStockTaking = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllSelfMaterial(["page" => $page, "pageSize" => $pageSize, "isStockTaking" => $isStockTaking]);
    }

    /**
     * 根据物料ids获取sku信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getSkusByMaterialIds (array $materialIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSkusByMaterialIds(["materialIds" => $materialIds]);
    }

    /**
     * 查询物料sku信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function searchMaterial () {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchMaterial([]);
    }

    /**
     * 获取sku分页列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getMaterialSkuListPage (string $keyword, int $source, int $page, int $pageSize) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMaterialSkuListPage(["keyword" => $keyword, "source" => $source, "page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}