<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-13 16:21:18
 */
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Common
 * @method getApproveByParams(array $params) 获取审批详情
 * @method getLogByParams(array $params) 获取日志信息
 * @method autoCreateNoByParams(array $params) 自动初始化每日单号
 * @method doCreateNoByParams(array $params) 手动初始化每日单号
 * @method getCountByStoreIdByParams(array $params) 根据门店id和时间查询采购数据
 * @method getCloseReasonByParams(array $params) 根据门店id和时间查询采购数据
 * @method redisSetByParams(array $params) redis信息设置
 */
class Common {
    private static string $serviceName = "ProjectSupplyChain";

    private static string $className = "Common";

    /**
     * 获取审批详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getApprove (string $processInstanceId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getApprove(["processInstanceId" => $processInstanceId]);
    }

    /**
     * 获取日志信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getLog (array $entities, int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getLog(["entities" => $entities, "page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 自动初始化每日单号
     * @return  void
    */
    public static function autoCreateNo () {
         RpcClass::getClass(self::$serviceName, self::$className)->autoCreateNo();
    }

    /**
     * 手动初始化每日单号
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  void
    */
    public static function doCreateNo (string $date) {
         RpcClass::getClass(self::$serviceName, self::$className)->doCreateNo(["date" => $date]);
    }

    /**
     * 根据门店id和时间查询采购数据
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getCountByStoreId (int $storeId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCountByStoreId(["storeId" => $storeId]);
    }

    /**
     * 根据门店id和时间查询采购数据
     * @return  array
    */
    public static function getCloseReason () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCloseReason();
    }

    /**
     * redis信息设置
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function redisSet (string $key) {
        return RpcClass::getClass(self::$serviceName, self::$className)->redisSet(["key" => $key]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}