<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-13 16:21:18
 */
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Bms;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class SelfInventory
 * @method selfInventoryListByParams(array $params) 盘点结果列表
 * @method detailByParams(array $params) 盘点结果详情
 * @method approveByParams(array $params) 盘点审批/批量审批 通过
 * @method approveReturnByParams(array $params) 盘点审批/批量审批 驳回
 * @method approveRevokeByParams(array $params) 盘点审批/批量审批 撤回
 * @method differenceByParams(array $params) 盘点差异
 * @method diffExportByParams(array $params) 未审核盘点差异导出
 * @method newTaskByParams(array $params) 创建导出任务
 * @method noticeByParams(array $params) 盘点提醒
 */
class SelfInventory {
    private static string $serviceName = "ProjectSupplyChain";

    private static string $className = "Bms\\SelfInventory";

    /**
     * 盘点结果列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function selfInventoryList (int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->selfInventoryList(["page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 盘点结果详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function detail (int $inventoryId, int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["inventoryId" => $inventoryId, "page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 盘点审批/批量审批 通过
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function approve (array $inventoryIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->approve(["inventoryIds" => $inventoryIds]);
    }

    /**
     * 盘点审批/批量审批 驳回
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function approveReturn (array $inventoryIds, string $remark) {
        return RpcClass::getClass(self::$serviceName, self::$className)->approveReturn(["inventoryIds" => $inventoryIds, "remark" => $remark]);
    }

    /**
     * 盘点审批/批量审批 撤回
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function approveRevoke (array $inventoryIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->approveRevoke(["inventoryIds" => $inventoryIds]);
    }

    /**
     * 盘点差异
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function difference (int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->difference(["page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 未审核盘点差异导出
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  string
    */
    public static function diffExport (string $template_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->diffExport(["template_id" => $template_id]);
    }

    /**
     * 创建导出任务
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  string
    */
    public static function newTask (string $template_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->newTask(["template_id" => $template_id]);
    }

    /**
     * 盘点提醒
     * @return  array
    */
    public static function notice () {
        return RpcClass::getClass(self::$serviceName, self::$className)->notice();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}