<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-13 16:21:18
 */
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Bms;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class RetailPurchaseDemand
 * @method createByParams(array $params) 创建零售成品需求单
 * @method detailByParams(array $params) 需求单详情
 * @method newTaskByParams(array $params) 新增导出任务
 * @method batchDealByParams(array $params) 批量处理
 * @method batchCloseByParams(array $params) 批量关闭
 * @method itemListByParams(array $params) 明细列表
 * @method listByParams(array $params) 需求单列表
 */
class RetailPurchaseDemand {
    private static string $serviceName = "ProjectSupplyChain";

    private static string $className = "Bms\\RetailPurchaseDemand";

    /**
     * 创建零售成品需求单
     * @return  mixed
    */
    public static function create (\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseDemand\CMD\RetailPurchaseDemandAddCMD $retailPurchaseDemandAddCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create($retailPurchaseDemandAddCMD);
    }

    /**
     * 需求单详情
     * @return  array
    */
    public static function detail (\Mainto\Bridge\Structs\ProjectSupplyChain\Basic\CMD\IDCMD $iDCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail($iDCMD);
    }

    /**
     * 新增导出任务
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  string
    */
    public static function newTask (string $template_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->newTask(["template_id" => $template_id]);
    }

    /**
     * 批量处理
     * @return  array
    */
    public static function batchDeal (\Mainto\Bridge\Structs\ProjectSupplyChain\Basic\CMD\IDsCMD $iDsCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->batchDeal($iDsCMD),
            "\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseDemand\DTO\RetailDemandDealDTO[]"
        );
    }

    /**
     * 批量关闭
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function batchClose (array $demandItemIds, string $closeReason, int $closeType = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchClose(["demandItemIds" => $demandItemIds, "closeReason" => $closeReason, "closeType" => $closeType]);
    }

    /**
     * 明细列表
     * @return  array
    */
    public static function itemList (?\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseDemand\CMD\RetailPurchaseDemandItemSearchListCMD $retailPurchaseDemandItemSearchListCMD = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->itemList($retailPurchaseDemandItemSearchListCMD);
    }

    /**
     * 需求单列表
     * @return  array
    */
    public static function list (?\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseDemand\CMD\RetailPurchaseDemandSearchListCMD $retailPurchaseDemandSearchListCMD = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list($retailPurchaseDemandSearchListCMD);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}