<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-13 16:21:18
 */
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Bms;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class RetailInventory
 * @method resultByParams(array $params) 零售盘点结果列表
 * @method detailByParams(array $params) 盘点结果详情
 * @method adjustDetailByParams(array $params) 盘点调整明细
 * @method approveByParams(array $params) 盘点审批通过
 * @method differenceByParams(array $params) 盘点差异
 * @method resultExportByParams(array $params) 结果导出
 * @method diffExportByParams(array $params) 差异导出
 */
class RetailInventory {
    private static string $serviceName = "ProjectSupplyChain";

    private static string $className = "Bms\\RetailInventory";

    /**
     * 零售盘点结果列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function result (int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->result(["page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 盘点结果详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function detail (int $inventoryId, int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["inventoryId" => $inventoryId, "page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 盘点调整明细
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function adjustDetail (int $inventoryId, int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->adjustDetail(["inventoryId" => $inventoryId, "page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 盘点审批通过
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function approve (array $inventoryIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->approve(["inventoryIds" => $inventoryIds]);
    }

    /**
     * 盘点差异
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function difference (int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->difference(["page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 结果导出
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  string
    */
    public static function resultExport (string $template_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->resultExport(["template_id" => $template_id]);
    }

    /**
     * 差异导出
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  string
    */
    public static function diffExport (string $template_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->diffExport(["template_id" => $template_id]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}