<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-13 16:21:18
 */
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Bms;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class BmsScrapMission
 * @method listByParams(array $params) 报废任务列表
 * @method missionDetailByParams(array $params) bms报废任务详情
 * @method createByParams(array $params) 新增报废任务
 * @method revokeByParams(array $params) 报废任务撤回
 * @method newTaskExportMissionDetailByParams(array $params) BMS报废任务详情导出
 * @method newTaskExportScrapProcessByParams(array $params) BMS报废审批导出
 * @method scrapProcessListByParams(array $params) BMS报废审批列表
 */
class BmsScrapMission {
    private static string $serviceName = "ProjectSupplyChain";

    private static string $className = "Bms\\BmsScrapMission";

    /**
     * 报废任务列表
     * @return  array
    */
    public static function list (?\Mainto\Bridge\Structs\ProjectSupplyChain\Scrap\Cmd\ScrapMissionListCMD $scrapMissionListCMD = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list($scrapMissionListCMD);
    }

    /**
     * bms报废任务详情
     * @return  array
    */
    public static function missionDetail (\Mainto\Bridge\Structs\ProjectSupplyChain\Scrap\Cmd\ScrapMissionDetailCMD $scrapMissionDetailCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->missionDetail($scrapMissionDetailCMD);
    }

    /**
     * 新增报废任务
     * @return  bool
    */
    public static function create (\Mainto\Bridge\Structs\ProjectSupplyChain\Scrap\Cmd\ScrapMissionCreateCMD $scrapMissionCreateCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create($scrapMissionCreateCMD);
    }

    /**
     * 报废任务撤回
     * @return  bool
    */
    public static function revoke (\Mainto\Bridge\Structs\ProjectSupplyChain\Scrap\Cmd\ScrapMissionRevokeCMD $scrapMissionRevokeCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->revoke($scrapMissionRevokeCMD);
    }

    /**
     * BMS报废任务详情导出
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  string
    */
    public static function newTaskExportMissionDetail (string $template_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->newTaskExportMissionDetail(["template_id" => $template_id]);
    }

    /**
     * BMS报废审批导出
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  string
    */
    public static function newTaskExportScrapProcess (string $template_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->newTaskExportScrapProcess(["template_id" => $template_id]);
    }

    /**
     * BMS报废审批列表
     * @return  array
    */
    public static function scrapProcessList (?\Mainto\Bridge\Structs\ProjectSupplyChain\Scrap\Cmd\ScrapMissionAndSkuListCMD $scrapMissionAndSkuListCMD = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->scrapProcessList($scrapMissionAndSkuListCMD);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}