<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getProductSkuPageListByParams(array|\Mainto\Bridge\Structs\ProjectSupplyChain\MaterialSku\Cmd\ProductSkuPageListCmd $params)
 * @method getProductSkuDetailByParams(array $params)
 * @method setProductSkuTransformInfoByParams(array|\Mainto\Bridge\Structs\ProjectSupplyChain\TransformInfo\Cmd\TransformInfoCreateCmd $params)
 * @method batchSetProductSkuTransformInfoByParams(array|\Mainto\Bridge\Structs\ProjectSupplyChain\TransformInfo\Cmd\TransformInfoBatchCreateCmd $params)
 */
class TransformInfo {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 成品 bom列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupplyChain\MaterialSku\Cmd\ProductSkuPageListCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectSupplyChain\MaterialSku\DTO\ProductSkuPageListDTO
     */
    public static function getProductSkuPageList (\Mainto\Bridge\Structs\ProjectSupplyChain\MaterialSku\Cmd\ProductSkuPageListCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getProductSkuPageList($cmd),
            "\Mainto\Bridge\Structs\ProjectSupplyChain\MaterialSku\DTO\ProductSkuPageListDTO"
        );
    }


    /**
     * 获取成品配方
     *
     * @param  int $productSkuId 成品id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductSkuDetail (int $productSkuId) {
        return self::getClass()->getProductSkuDetail([
            "productSkuId" => $productSkuId,
        ]);
    }

    /**
     * 设置成品配方
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupplyChain\TransformInfo\Cmd\TransformInfoCreateCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function setProductSkuTransformInfo (\Mainto\Bridge\Structs\ProjectSupplyChain\TransformInfo\Cmd\TransformInfoCreateCmd $cmd) {
        return self::getClass()->setProductSkuTransformInfo($cmd);
    }


    /**
     * 批量设置配方
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupplyChain\TransformInfo\Cmd\TransformInfoBatchCreateCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function batchSetProductSkuTransformInfo (\Mainto\Bridge\Structs\ProjectSupplyChain\TransformInfo\Cmd\TransformInfoBatchCreateCmd $cmd) {
        return self::getClass()->batchSetProductSkuTransformInfo($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'TransformInfo');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'TransformInfo');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}