<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Store;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method storeDealScrapAndInventoryByParams(array $params)
 * @method missionAndSkuListByParams(array|\Mainto\Bridge\Structs\ProjectSupplyChain\Scrap\Cmd\ScrapMissionAndSkuListCMD $params)
 * @method detailByParams(array|\Mainto\Bridge\Structs\ProjectSupplyChain\Scrap\Cmd\ScrapDetailCMD $params)
 * @method checkByParams(array|\Mainto\Bridge\Structs\ProjectSupplyChain\Scrap\Cmd\ScrapCheckCMD $params)
 * @method getMissionStatusCountByParams(array $params)
 * @method missionListByParams(array|\Mainto\Bridge\Structs\ProjectSupplyChain\Scrap\Cmd\ScrapMissionListCMD $params)
 * @method newTaskExportScrapProcessByParams(array $params)
 */
class SelfScrap {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * [领用助手]-首页获取盘点+报废处理单数量
     *
     * @throws  \Exception
     * @return  int
     */
    public static function storeDealScrapAndInventory () {
        return self::getClass()->storeDealScrapAndInventory();
    }

    /**
     * [报废任务] 门店报废单列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupplyChain\Scrap\Cmd\ScrapMissionAndSkuListCMD $cmd
     * @throws  \Exception
     * @return  array
     */
    public static function missionAndSkuList (\Mainto\Bridge\Structs\ProjectSupplyChain\Scrap\Cmd\ScrapMissionAndSkuListCMD $cmd) {
        return self::getClass()->missionAndSkuList($cmd);
    }


    /**
     * [报废任务] 门店报废单详情
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupplyChain\Scrap\Cmd\ScrapDetailCMD $cmd
     * @throws  \Exception
     * @return  array
     */
    public static function detail (\Mainto\Bridge\Structs\ProjectSupplyChain\Scrap\Cmd\ScrapDetailCMD $cmd) {
        return self::getClass()->detail($cmd);
    }


    /**
     * [报废任务] 提交报废单
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupplyChain\Scrap\Cmd\ScrapCheckCMD $checkCMD
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectSupplyChain\Basic\DTO\CheckScrapErrDTO
     */
    public static function check (\Mainto\Bridge\Structs\ProjectSupplyChain\Scrap\Cmd\ScrapCheckCMD $checkCMD) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->check($checkCMD),
            "\Mainto\Bridge\Structs\ProjectSupplyChain\Basic\DTO\CheckScrapErrDTO"
        );
    }


    /**
     * [报废任务] 任务状态数量
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getMissionStatusCount () {
        return self::getClass()->getMissionStatusCount();
    }

    /**
     * [报废任务]列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupplyChain\Scrap\Cmd\ScrapMissionListCMD $listCMD
     * @throws  \Exception
     * @return  array
     */
    public static function missionList (\Mainto\Bridge\Structs\ProjectSupplyChain\Scrap\Cmd\ScrapMissionListCMD $listCMD) {
        return self::getClass()->missionList($listCMD);
    }


    /**
     * 门店报废审批导出
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $params 参数 [ require false ]
     * @throws  \Exception
     * @return  string
     */
    public static function newTaskExportScrapProcess () {
        return self::getClass()->newTaskExportScrapProcess([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Store\SelfScrap');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Store\SelfScrap');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}