<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getListByParams(array $params)
 * @method batchProductTagBindProductCheckDataByParams(array $params)
 * @method batchProductTagBindProductByParams(array $params)
 * @method getAllListByParams(array $params)
 */
class ProductTagProduct {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取标签下绑定的产品
     *
     * @support  int $productTagId 标签id [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getList () {
        return self::getClass()->getList([
        ]);
    }

    /**
     * 标签批量绑定产品
     *
     * @param  array $bindData 数据 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function batchProductTagBindProductCheckData (array $bindData) {
        return self::getClass()->batchProductTagBindProductCheckData([
            "bindData" => $bindData,
        ]);
    }

    /**
     * 标签批量绑定产品
     *
     * @param  array $bindData 数据 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchProductTagBindProduct (array $bindData) {
        return self::getClass()->batchProductTagBindProduct([
            "bindData" => $bindData,
        ]);
    }

    /**
     * 获取已绑定所有的产品
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getAllList () {
        return self::getClass()->getAllList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'ProductTagProduct');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'ProductTagProduct');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}