<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method getItemsByParams(array $params)
 * @method getListPaginationByParams(array $params)
 * @method getListByParams(array $params)
 * @method approvalRevokeByParams(array|\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseEntry\CMD\PurchaseEntryApprovalRevokeReq $params)
 * @method closePurchaseEntryByParams(array|\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseEntry\CMD\PurchaseEntryCloseReq $params)
 * @method updateEntryByParams(array|\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseEntry\CMD\PurchaseEntryUpdateReq $params)
 * @method purchaseEntryEnumsByParams(array $params)
 */
class PurchaseEntry {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建入库单
     *
     * @support  int $storageId 入库仓库id [ require false ]
     * @support  string $content 备注 [ require false ]
     * @support  string $operationType 业务类型 [ require false ]
     * @support  int $source 来源 [ require false ]
     * @support  string $type 出入库类型 [ require false ]
     * @support  array $items 入库单列表 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 获取入库单子单
     *
     * @support  int $entryId 入库单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getItems () {
        return self::getClass()->getItems([
        ]);
    }

    /**
     * 分页查询入库单列表
     *
     * @support  string $entryNo 入库单no [ require false ]
     * @support  int $storageId 仓库id [ require false ]
     * @support  string $createdAtStart 开始时间 [ require false ]
     * @support  string $createdAtEnd 终止时间 [ require false ]
     * @support  int $source 来源 [ require false ]
     * @support  string $status 审批状态 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getListPagination () {
        return self::getClass()->getListPagination([
        ]);
    }

    /**
     * 退款单列表不分页
     *
     * @support  string $entryNo 入库单no [ require false ]
     * @support  int $storageId 仓库id [ require false ]
     * @support  string $createdAtStart 开始时间 [ require false ]
     * @support  string $createdAtEnd 终止时间 [ require false ]
     * @support  int $source 来源 [ require false ]
     * @support  string $status 审批状态 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getList () {
        return self::getClass()->getList([
        ]);
    }

    /**
     * 撤回审批
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseEntry\CMD\PurchaseEntryApprovalRevokeReq $approvalRevokeCMD
     * @throws  \Exception
     * @return  bool
     */
    public static function approvalRevoke (\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseEntry\CMD\PurchaseEntryApprovalRevokeReq $approvalRevokeCMD) {
        return self::getClass()->approvalRevoke($approvalRevokeCMD);
    }


    /**
     * 订单关闭
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseEntry\CMD\PurchaseEntryCloseReq $purchaseEntryCloseReq
     * @throws  \Exception
     * @return  bool
     */
    public static function closePurchaseEntry (\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseEntry\CMD\PurchaseEntryCloseReq $purchaseEntryCloseReq) {
        return self::getClass()->closePurchaseEntry($purchaseEntryCloseReq);
    }


    /**
     * 订单更新
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseEntry\CMD\PurchaseEntryUpdateReq $purchaseEntryUpdateReq
     * @throws  \Exception
     * @return  bool
     */
    public static function updateEntry (\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseEntry\CMD\PurchaseEntryUpdateReq $purchaseEntryUpdateReq) {
        return self::getClass()->updateEntry($purchaseEntryUpdateReq);
    }


    /**
     * 枚举
     *
     * @throws  \Exception
     * @return  array
     */
    public static function purchaseEntryEnums () {
        return self::getClass()->purchaseEntryEnums();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'PurchaseEntry');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'PurchaseEntry');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}