<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Bms;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array|\Mainto\Bridge\Structs\ProjectSupplyChain\Allocation\CMD\AllocationPaginateSearchCMD $params)
 * @method detailByParams(array $params)
 * @method detailItemListByParams(array|\Mainto\Bridge\Structs\ProjectSupplyChain\Allocation\CMD\AllocationItemPaginateSearchCMD $params)
 * @method getPredictDataByParams(array|\Mainto\Bridge\Structs\ProjectSupplyChain\Allocation\CMD\AllocationAddCMD $params)
 * @method getBatchPredictDataByParams(array|\Mainto\Bridge\Structs\ProjectSupplyChain\Allocation\CMD\AllocationBatchAddCMD $params)
 * @method createByParams(array|\Mainto\Bridge\Structs\ProjectSupplyChain\Allocation\CMD\AllocationAddCMD $params)
 * @method batchCreateByParams(array|\Mainto\Bridge\Structs\ProjectSupplyChain\Allocation\CMD\AllocationBatchAddCMD $params)
 * @method searchMaterialByParams(array $params)
 * @method exportBatchShipAddByParams(array $params)
 * @method getStorageServiceByParams(array $params)
 */
class SelfAllocation {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 和零售有区别的点，这里的列表不用区分调拨单的创建方，其实是去掉了 createType 的筛选条件
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupplyChain\Allocation\CMD\AllocationPaginateSearchCMD $CMD
     * @throws  \Exception
     * @return  array
     */
    public static function list (\Mainto\Bridge\Structs\ProjectSupplyChain\Allocation\CMD\AllocationPaginateSearchCMD $CMD) {
        return self::getClass()->list($CMD);
    }


    /**
     * 调拨单详情
     *
     * @param  int $id 调拨单id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectSupplyChain\Allocation\DTO\AllocationDetailDTO
     */
    public static function detail (int $id) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail([
                            "id" => $id,
                        ]),
            "\Mainto\Bridge\Structs\ProjectSupplyChain\Allocation\DTO\AllocationDetailDTO"
        );
    }

    /**
     * 调拨单详情页商品搜索
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupplyChain\Allocation\CMD\AllocationItemPaginateSearchCMD $CMD
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectSupplyChain\Allocation\DTO\AllocationItemPageDTO
     */
    public static function detailItemList (\Mainto\Bridge\Structs\ProjectSupplyChain\Allocation\CMD\AllocationItemPaginateSearchCMD $CMD) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detailItemList($CMD),
            "\Mainto\Bridge\Structs\ProjectSupplyChain\Allocation\DTO\AllocationItemPageDTO"
        );
    }


    /**
     * 调拨,单条发货时间检查
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupplyChain\Allocation\CMD\AllocationAddCMD $addCMD
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectSupplyChain\Basic\DTO\ErrDTO
     */
    public static function getPredictData (\Mainto\Bridge\Structs\ProjectSupplyChain\Allocation\CMD\AllocationAddCMD $addCMD) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getPredictData($addCMD),
            "\Mainto\Bridge\Structs\ProjectSupplyChain\Basic\DTO\ErrDTO"
        );
    }


    /**
     * 调拨,多条发货时间检查
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupplyChain\Allocation\CMD\AllocationBatchAddCMD $CMD
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectSupplyChain\Basic\DTO\ErrDTO
     */
    public static function getBatchPredictData (\Mainto\Bridge\Structs\ProjectSupplyChain\Allocation\CMD\AllocationBatchAddCMD $CMD) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getBatchPredictData($CMD),
            "\Mainto\Bridge\Structs\ProjectSupplyChain\Basic\DTO\ErrDTO"
        );
    }


    /**
     * 新增调拨
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupplyChain\Allocation\CMD\AllocationAddCMD $addCMD
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectSupplyChain\Basic\DTO\CheckPassDTO
     */
    public static function create (\Mainto\Bridge\Structs\ProjectSupplyChain\Allocation\CMD\AllocationAddCMD $addCMD) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->create($addCMD),
            "\Mainto\Bridge\Structs\ProjectSupplyChain\Basic\DTO\CheckPassDTO"
        );
    }


    /**
     * 新增批量调拨
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupplyChain\Allocation\CMD\AllocationBatchAddCMD $CMD
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchCreate (\Mainto\Bridge\Structs\ProjectSupplyChain\Allocation\CMD\AllocationBatchAddCMD $CMD) {
        return self::getClass()->batchCreate($CMD);
    }


    /**
     * 搜索物料-物料表搜
     *
     * @param  string $keyword 搜索关键词 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function searchMaterial (string $keyword) {
        return self::getClass()->searchMaterial([
            "keyword" => $keyword,
        ]);
    }

    /**
     * 批量发货模板下载-导出查询结果
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $params 参数 [ require false ]
     * @throws  \Exception
     * @return  string
     */
    public static function exportBatchShipAdd () {
        return self::getClass()->exportBatchShipAdd([
        ]);
    }

    /**
     * getStorageService
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStorageService () {
        return self::getClass()->getStorageService();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Bms\SelfAllocation');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Bms\SelfAllocation');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}