<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Bms;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array|\Mainto\Bridge\Structs\ProjectSupplyChain\Scrap\Cmd\ScrapMissionListCMD $params)
 * @method missionDetailByParams(array|\Mainto\Bridge\Structs\ProjectSupplyChain\Scrap\Cmd\ScrapMissionDetailCMD $params)
 * @method createByParams(array|\Mainto\Bridge\Structs\ProjectSupplyChain\Scrap\Cmd\ScrapMissionCreateCMD $params)
 * @method revokeByParams(array|\Mainto\Bridge\Structs\ProjectSupplyChain\Scrap\Cmd\ScrapMissionRevokeCMD $params)
 * @method newTaskExportMissionDetailByParams(array $params)
 * @method newTaskExportScrapProcessByParams(array $params)
 * @method scrapProcessListByParams(array|\Mainto\Bridge\Structs\ProjectSupplyChain\Scrap\Cmd\ScrapMissionAndSkuListCMD $params)
 */
class BmsScrapMission {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 报废任务列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupplyChain\Scrap\Cmd\ScrapMissionListCMD $listCMD
     * @throws  \Exception
     * @return  array
     */
    public static function list (\Mainto\Bridge\Structs\ProjectSupplyChain\Scrap\Cmd\ScrapMissionListCMD $listCMD) {
        return self::getClass()->list($listCMD);
    }


    /**
     * bms报废任务详情
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupplyChain\Scrap\Cmd\ScrapMissionDetailCMD $detailCMD
     * @throws  \Exception
     * @return  array
     */
    public static function missionDetail (\Mainto\Bridge\Structs\ProjectSupplyChain\Scrap\Cmd\ScrapMissionDetailCMD $detailCMD) {
        return self::getClass()->missionDetail($detailCMD);
    }


    /**
     * 新增报废任务
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupplyChain\Scrap\Cmd\ScrapMissionCreateCMD $createCMD
     * @throws  \Exception
     * @return  bool
     */
    public static function create (\Mainto\Bridge\Structs\ProjectSupplyChain\Scrap\Cmd\ScrapMissionCreateCMD $createCMD) {
        return self::getClass()->create($createCMD);
    }


    /**
     * 报废任务撤回
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupplyChain\Scrap\Cmd\ScrapMissionRevokeCMD $revokeCMD
     * @throws  \Exception
     * @return  bool
     */
    public static function revoke (\Mainto\Bridge\Structs\ProjectSupplyChain\Scrap\Cmd\ScrapMissionRevokeCMD $revokeCMD) {
        return self::getClass()->revoke($revokeCMD);
    }


    /**
     * BMS报废任务详情导出
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $params 参数 [ require false ]
     * @throws  \Exception
     * @return  string
     */
    public static function newTaskExportMissionDetail () {
        return self::getClass()->newTaskExportMissionDetail([
        ]);
    }

    /**
     * BMS报废审批导出
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $params 参数 [ require false ]
     * @throws  \Exception
     * @return  string
     */
    public static function newTaskExportScrapProcess () {
        return self::getClass()->newTaskExportScrapProcess([
        ]);
    }

    /**
     * BMS报废审批列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupplyChain\Scrap\Cmd\ScrapMissionAndSkuListCMD $cmd
     * @throws  \Exception
     * @return  array
     */
    public static function scrapProcessList (\Mainto\Bridge\Structs\ProjectSupplyChain\Scrap\Cmd\ScrapMissionAndSkuListCMD $cmd) {
        return self::getClass()->scrapProcessList($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Bms\BmsScrapMission');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Bms\BmsScrapMission');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}