<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createdByParams(array|\Mainto\Bridge\Structs\ProjectSupplyChain\ProcessOrder\Cmd\ProcessOrderBatchCreateCmd $params)
 * @method getPageListByParams(array|\Mainto\Bridge\Structs\ProjectSupplyChain\ProcessOrder\Cmd\ProcessOrderListPageCmd $params)
 * @method detailByParams(array $params)
 * @method getProductSkuTransformByParams(array $params)
 */
class ProcessOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建加工单
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupplyChain\ProcessOrder\Cmd\ProcessOrderBatchCreateCmd $params
     * @throws  \Exception
     * @return  array
     */
    public static function created (\Mainto\Bridge\Structs\ProjectSupplyChain\ProcessOrder\Cmd\ProcessOrderBatchCreateCmd $params) {
        return self::getClass()->created($params);
    }


    /**
     * 加工单分页列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupplyChain\ProcessOrder\Cmd\ProcessOrderListPageCmd $params
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectSupplyChain\ProcessOrder\DTO\ProcessOrderPageListDTO
     */
    public static function getPageList (\Mainto\Bridge\Structs\ProjectSupplyChain\ProcessOrder\Cmd\ProcessOrderListPageCmd $params) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getPageList($params),
            "\Mainto\Bridge\Structs\ProjectSupplyChain\ProcessOrder\DTO\ProcessOrderPageListDTO"
        );
    }


    /**
     * 加工单详情
     *
     * @param  int $processOrderId 加工单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $processOrderId) {
        return self::getClass()->detail([
            "processOrderId" => $processOrderId,
        ]);
    }

    /**
     * 获取成品加工组合
     *
     * @param  array $productSkuIds 成品skuId [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductSkuTransform (array $productSkuIds) {
        return self::getClass()->getProductSkuTransform([
            "productSkuIds" => $productSkuIds,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'ProcessOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'ProcessOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}