<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Store;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method restockSubmitByParams(array|\Mainto\Bridge\Structs\ProjectSupplyChain\Restock\CMD\RestockSaveCMD $params)
 * @method detailByParams(array $params)
 */
class SelfRestock {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * [购物车]-提交补货单
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupplyChain\Restock\CMD\RestockSaveCMD $cmd
     * @throws  \Exception
     * @return  array
     */
    public static function restockSubmit (\Mainto\Bridge\Structs\ProjectSupplyChain\Restock\CMD\RestockSaveCMD $cmd) {
        return self::getClass()->restockSubmit($cmd);
    }


    /**
     * [购物车]-补货单详情
     *
     * @param  int $scrapId 报废单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $scrapId) {
        return self::getClass()->detail([
            "scrapId" => $scrapId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Store\SelfRestock');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Store\SelfRestock');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}