<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Bms;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method importTemplateByParams(array $params)
 * @method importByParams(array $params)
 * @method batchSendByParams(array $params)
 * @method batchUpdateByParams(array $params)
 * @method batchCloseByParams(array $params)
 * @method getCreateByInfosByParams(array $params)
 * @method newTaskByParams(array $params)
 */
class RetailPurchaseShipNotice {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 发货通知单导入模板
     *
     * @param  array $noticeIds 发货通知单ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function importTemplate (array $noticeIds) {
        return self::getClass()->importTemplate([
            "noticeIds" => $noticeIds,
        ]);
    }

    /**
     * 导入快递单号和数量
     *
     * @param  array $data 数据 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function import (array $data) {
        return self::getClass()->import([
            "data" => $data,
        ]);
    }

    /**
     * 批量发运
     *
     * @param  array $noticeIds 发货通知单ids [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchSend (array $noticeIds) {
        return self::getClass()->batchSend([
            "noticeIds" => $noticeIds,
        ]);
    }

    /**
     * 批量更新
     *
     * @param  array $data 待修改的信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function batchUpdate (array $data) {
        return self::getClass()->batchUpdate([
            "data" => $data,
        ]);
    }

    /**
     * 批量关闭
     *
     * @param  array $data 待关闭的信息 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchClose (array $data) {
        return self::getClass()->batchClose([
            "data" => $data,
        ]);
    }

    /**
     * 获取创建人s
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCreateByInfos () {
        return self::getClass()->getCreateByInfos();
    }

    /**
     * 新增导出任务
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $params 参数 [ require false ]
     * @throws  \Exception
     * @return  string
     */
    public static function newTask () {
        return self::getClass()->newTask([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Bms\RetailPurchaseShipNotice');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Bms\RetailPurchaseShipNotice');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}