<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Supplier;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getUserInfoByParams(array $params)
 * @method getUserInfoAByParams(array $params)
 */
class SupplierAccount {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取用户信息
     *
     * @param  int $userId 用户icd [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserInfo (int $userId) {
        return self::getClass()->getUserInfo([
            "userId" => $userId,
        ]);
    }

    /**
     * 获取用户信息
     *
     * @param  int $userId 用户icd [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserInfoA (int $userId) {
        return self::getClass()->getUserInfoA([
            "userId" => $userId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Supplier\SupplierAccount');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Supplier\SupplierAccount');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}