<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Store;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method checkDetailByParams(array $params)
 * @method getMissionDetailByParams(array|\Mainto\Bridge\Structs\ProjectSupplyChain\Inventory\Cmd\GetMissionDetailCmd $params)
 * @method searchSkuByParams(array $params)
 * @method checkByParams(array $params)
 * @method recheckByParams(array $params)
 * @method importStoreStockByParams(array $params)
 * @method storageStockBySkuIdByParams(array $params)
 * @method getMissionAndSkuListByParams(array|\Mainto\Bridge\Structs\ProjectSupplyChain\Inventory\Cmd\GetMissionAndSkuListCmd $params)
 */
class SelfInventory {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 自用盘点列表
     *
     * @support  string $status 盘点提交状态 [ require false ]
     * @support  string $approveStatus 盘点审核状态 [ require false ]
     * @support  string $inventoryType 盘点发起类型|总部or自发 [ require false ]
     * @support  string $inventoryStart 盘点日期开始 [ require false ]
     * @support  string $inventoryEnd 盘点日期结束 [ require false ]
     * @param  int $page 当前页 [ require false ]
     * @param  int $pageSize 页内条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 未盘点过，第一次点盘点无实际数量
     * 盘点被打回，则取盘点明细
     *
     * @support  int $inventoryId 盘点ID [ require true ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 页大小 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function checkDetail (int $page = 1, int $pageSize = 10) {
        return self::getClass()->checkDetail([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 未盘点过，第一次点盘点无实际数量
     * 盘点被打回，则取盘点明细
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupplyChain\Inventory\Cmd\GetMissionDetailCmd $cmd
     * @throws  \Exception
     * @return  array
     */
    public static function getMissionDetail (\Mainto\Bridge\Structs\ProjectSupplyChain\Inventory\Cmd\GetMissionDetailCmd $cmd) {
        return self::getClass()->getMissionDetail($cmd);
    }


    /**
     * 未盘点过，第一次点盘点无实际数量
     * 盘点被打回，则取盘点明细
     *
     * @support  int $inventoryId 盘点ID [ require true ]
     * @support  string $skuCode skuCode [ require false ]
     * @support  string $skuName skuName [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function searchSku () {
        return self::getClass()->searchSku([
        ]);
    }

    /**
     * 提交盘点结果
     * 总部盘点预先生成inventory，门店自盘则新建
     *
     * @support  array $skuInfos 盘点商品数组 [ require true ]
     * @support  int $inventoryId 盘点ID [ require false ]
     * @support  string $inventoryType 盘点类型store,office [ require true ]
     * @support  int $isAutoApprove 是否自动通过，零售为自动通过 [ require false ]
     * @support  string $submit_remark 盘点提交说明 [ require false ]
     * @support  string $refuse_remark 盘点驳回说明 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function check () {
        return self::getClass()->check([
        ]);
    }

    /**
     * 被驳回后再提交盘点结果
     * [item_id],sku_id,actual_amount
     *
     * @support  int $inventoryId 盘点ID [ require true ]
     * @support  array $skuInfos 盘点商品数组 [ require true ]
     * @support  string $submit_remark 盘点提交说明 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function recheck () {
        return self::getClass()->recheck([
        ]);
    }

    /**
     * 导入门店库存
     *
     * @throws  \Exception
     * @return  array
     */
    public static function importStoreStock () {
        return self::getClass()->importStoreStock();
    }

    /**
     * 获取门店里指定skuid的库存信息
     *
     * @support  array $skuids skuid [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function storageStockBySkuId () {
        return self::getClass()->storageStockBySkuId([
        ]);
    }

    /**
     * (盘点助手) 盘点任务列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupplyChain\Inventory\Cmd\GetMissionAndSkuListCmd $cmd
     * @throws  \Exception
     * @return  array
     */
    public static function getMissionAndSkuList (\Mainto\Bridge\Structs\ProjectSupplyChain\Inventory\Cmd\GetMissionAndSkuListCmd $cmd) {
        return self::getClass()->getMissionAndSkuList($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Store\SelfInventory');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Store\SelfInventory');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}